/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet.servicelist;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.servicelist.FormattedServiceListWriter;
import org.apache.cxf.transport.servlet.servicelist.ServiceListJAASAuthenticator;
import org.apache.cxf.transport.servlet.servicelist.ServiceListWriter;
import org.apache.cxf.transport.servlet.servicelist.UnformattedServiceListWriter;

public class ServiceListGeneratorServlet
extends HttpServlet {
    private static final long serialVersionUID = -113918058557537996L;
    private DestinationRegistry destinationRegistry;
    private Bus bus;
    private String serviceListStyleSheet;
    private String title = "CXF - Service list";
    private boolean showForeignContexts = true;

    public ServiceListGeneratorServlet(DestinationRegistry destinationRegistry, Bus bus) {
        this.destinationRegistry = destinationRegistry;
        this.bus = bus != null ? bus : BusFactory.getDefaultBus(false);
    }

    public void setServiceListStyleSheet(String serviceListStyleSheet) {
        this.serviceListStyleSheet = serviceListStyleSheet;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServiceListWriter serviceListWriter;
        Object isAuthServiceList = request.getAttribute("auth.service.list");
        if (isAuthServiceList != null && Boolean.valueOf(isAuthServiceList.toString()).booleanValue()) {
            String authServiceListRealm = (String)request.getAttribute("auth.service.list.realm");
            ServiceListJAASAuthenticator authenticator = new ServiceListJAASAuthenticator();
            authenticator.setRealm(authServiceListRealm);
            if (!authenticator.authenticate(request, response)) {
                return;
            }
            request.removeAttribute("auth.service.list");
            request.removeAttribute("auth.service.list.realm");
        }
        if (request.getParameter("stylesheet") != null) {
            this.renderStyleSheet(request, response);
            return;
        }
        if ("HEAD".equals(request.getMethod())) {
            return;
        }
        if (this.bus == null) {
            this.bus = BusFactory.getDefaultBus(false);
        }
        if ("false".equals(request.getParameter("formatted"))) {
            boolean renderWsdlList = "true".equals(request.getParameter("wsdlList"));
            serviceListWriter = new UnformattedServiceListWriter(renderWsdlList, this.bus);
        } else {
            String styleSheetPath;
            if (this.serviceListStyleSheet != null) {
                styleSheetPath = request.getContextPath() + "/" + this.serviceListStyleSheet;
            } else {
                String pathInfo;
                String servletPath;
                styleSheetPath = "";
                String contextPath = request.getContextPath();
                if (contextPath != null) {
                    styleSheetPath = styleSheetPath + contextPath;
                }
                if ((servletPath = request.getServletPath()) != null) {
                    styleSheetPath = styleSheetPath + servletPath;
                }
                if ((pathInfo = request.getPathInfo()) != null) {
                    styleSheetPath = styleSheetPath + pathInfo;
                }
                if (!styleSheetPath.endsWith("/")) {
                    styleSheetPath = styleSheetPath + "/";
                }
                styleSheetPath = styleSheetPath + "?stylesheet=1";
            }
            serviceListWriter = new FormattedServiceListWriter(styleSheetPath, this.title, this.showForeignContexts, this.bus);
        }
        response.setContentType(serviceListWriter.getContentType());
        Object basePath = request.getAttribute(Message.BASE_PATH);
        AbstractDestination[] destinations = this.destinationRegistry.getSortedDestinations();
        List<String> privateEndpoints = this.bus != null ? CastUtils.cast((List)this.bus.getProperty("org.apache.cxf.private.endpoints")) : Collections.emptyList();
        serviceListWriter.writeServiceList(response.getWriter(), basePath == null ? null : basePath.toString(), ServiceListGeneratorServlet.getSOAPEndpoints(destinations, privateEndpoints), ServiceListGeneratorServlet.getRestEndpoints(destinations, privateEndpoints));
    }

    private static boolean isPrivate(EndpointInfo ei, List<String> privateEndpoints) {
        if (privateEndpoints != null) {
            for (String s : privateEndpoints) {
                if (!ei.getAddress().endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    private static AbstractDestination[] getSOAPEndpoints(AbstractDestination[] destinations, List<String> privateEndpoints) {
        ArrayList<AbstractDestination> soapEndpoints = new ArrayList<AbstractDestination>();
        for (AbstractDestination sd : destinations) {
            if (null == sd.getEndpointInfo().getName() || null == sd.getEndpointInfo().getInterface() || ServiceListGeneratorServlet.isPrivate(sd.getEndpointInfo(), privateEndpoints)) continue;
            soapEndpoints.add(sd);
        }
        return soapEndpoints.toArray(new AbstractDestination[0]);
    }

    private static AbstractDestination[] getRestEndpoints(AbstractDestination[] destinations, List<String> privateEndpoints) {
        ArrayList<AbstractDestination> restfulDests = new ArrayList<AbstractDestination>();
        for (AbstractDestination sd : destinations) {
            if (null != sd.getEndpointInfo().getInterface() || ServiceListGeneratorServlet.isPrivate(sd.getEndpointInfo(), privateEndpoints)) continue;
            restfulDests.add(sd);
        }
        return restfulDests.toArray(new AbstractDestination[0]);
    }

    private void renderStyleSheet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/css; charset=UTF-8");
        URL url = this.getClass().getResource("servicelist.css");
        if (url != null) {
            try (InputStream inputStream = url.openStream();){
                IOUtils.copy(inputStream, response.getOutputStream());
            }
        }
    }

    @Override
    public void init(ServletConfig servletConfig) {
        String showAllContexts;
        String configTitle;
        String configServiceListStyleSheet = servletConfig.getInitParameter("service-list-stylesheet");
        if (!StringUtils.isEmpty(configServiceListStyleSheet)) {
            this.serviceListStyleSheet = configServiceListStyleSheet;
        }
        if (!StringUtils.isEmpty(configTitle = servletConfig.getInitParameter("service-list-title"))) {
            this.title = configTitle;
        }
        if (!StringUtils.isEmpty(showAllContexts = servletConfig.getInitParameter("service-list-all-contexts"))) {
            this.showForeignContexts = Boolean.valueOf(showAllContexts);
        }
    }

    @Override
    public ServletConfig getServletConfig() {
        return null;
    }

    @Override
    public String getServletInfo() {
        return null;
    }

    @Override
    public void destroy() {
    }
}

