/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import org.apache.cxf.message.Message;

public class ServletOutputStreamFilter
extends ServletOutputStream {
    private Message m;
    private ServletOutputStream os;

    public ServletOutputStreamFilter(ServletOutputStream os, Message m) {
        this.os = os;
        this.m = m;
    }

    @Override
    public void write(int b) throws IOException {
        this.setComittedStatus();
        this.os.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.setComittedStatus();
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.setComittedStatus();
        this.os.write(b, off, len);
    }

    private void setComittedStatus() {
        this.m.getExchange().put("http.response.done", Boolean.TRUE);
    }

    @Override
    public boolean isReady() {
        return this.os.isReady();
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
        this.os.setWriteListener(writeListener);
    }
}

