/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.FrontendClientAdapter;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.UrlEncodingParamConverter;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.jaxrs.impl.FeatureContextImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.service.factory.FactoryBeanListener;

public class JAXRSClientFactoryBean
extends AbstractJAXRSFactoryBean {
    protected static final Logger LOG = LogUtils.getL7dLogger(JAXRSClientFactoryBean.class);
    protected String username;
    protected String password;
    protected boolean inheritHeaders;
    protected MultivaluedMap<String, String> headers;
    protected ClientState initialState;
    protected boolean threadSafe;
    protected long timeToKeepState;
    protected Class<?> serviceClass;
    protected ClassLoader proxyLoader;

    public JAXRSClientFactoryBean() {
        this(new JAXRSServiceFactoryBean());
    }

    public JAXRSClientFactoryBean(JAXRSServiceFactoryBean serviceFactory) {
        super(serviceFactory);
        serviceFactory.setEnableStaticResolution(true);
    }

    public void setClassLoader(ClassLoader loader) {
        this.proxyLoader = loader;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public void setSecondsToKeepState(long time) {
        this.timeToKeepState = time;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInheritHeaders(boolean ih) {
        this.inheritHeaders = ih;
    }

    public void setResourceClass(Class<?> cls) {
        this.setServiceClass(cls);
    }

    public void setServiceClass(Class<?> cls) {
        this.serviceClass = cls;
        this.serviceFactory.setResourceClass(cls);
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = new MetadataMap<String, String>();
        map.forEach((key, value) -> {
            String[] values;
            for (String v : values = value.split(",")) {
                if (v.length() == 0) continue;
                this.headers.add((String)key, v);
            }
        });
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public WebClient createWebClient() {
        int queryIndex;
        String serviceAddress = this.getAddress();
        int n = queryIndex = serviceAddress != null ? serviceAddress.lastIndexOf(63) : -1;
        if (queryIndex != -1) {
            serviceAddress = serviceAddress.substring(0, queryIndex);
        }
        JAXRSServiceImpl service = new JAXRSServiceImpl(serviceAddress, this.getServiceName());
        this.getServiceFactory().setService(service);
        try {
            Endpoint ep = this.createEndpoint();
            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.PRE_CLIENT_CREATE, ep);
            ClientState actualState = this.getActualState();
            WebClient client = actualState == null ? new WebClient(this.getAddress(), this.getProperties()) : new WebClient(actualState);
            this.initClient(client, ep, actualState == null);
            this.notifyLifecycleManager(client);
            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.CLIENT_CREATED, client, ep);
            return client;
        }
        catch (Exception ex) {
            LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    protected void notifyLifecycleManager(Object client) {
        ClientLifeCycleManager mgr = this.bus.getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientCreated(new FrontendClientAdapter(WebClient.getConfig(client)));
        }
    }

    protected ClientState getActualState() {
        if (this.threadSafe) {
            this.initialState = new ThreadLocalClientState(this.getAddress(), this.timeToKeepState, this.getProperties());
        }
        if (this.initialState != null) {
            return this.headers != null ? this.initialState.newState(URI.create(this.getAddress()), this.headers, null, this.getProperties()) : this.initialState;
        }
        return null;
    }

    public <T> T create(Class<T> cls, Object ... varValues) {
        return cls.cast(this.createWithValues(varValues));
    }

    public Client create() {
        if (this.serviceClass == WebClient.class) {
            return this.createWebClient();
        }
        return this.createWithValues(new Object[0]);
    }

    public Client createWithValues(Object ... varValues) {
        this.serviceFactory.setBus(this.getBus());
        this.checkResources(false);
        AbstractResourceInfo cri = null;
        try {
            Endpoint ep = this.createEndpoint();
            if (this.getServiceClass() != null) {
                for (ClassResourceInfo info : this.serviceFactory.getClassResourceInfo()) {
                    if (!info.getServiceClass().isAssignableFrom(this.getServiceClass()) && !this.getServiceClass().isAssignableFrom(info.getServiceClass())) continue;
                    cri = info;
                    break;
                }
                if (cri == null) {
                    throw new RuntimeException("Service class " + this.getServiceClass().getName() + " is not recognized");
                }
            } else {
                cri = this.serviceFactory.getClassResourceInfo().get(0);
            }
            boolean isRoot = ((ClassResourceInfo)cri).getURITemplate() != null;
            ClientState actualState = this.getActualState();
            ClientProxyImpl proxyImpl = this.createClientProxy((ClassResourceInfo)cri, isRoot, actualState, varValues);
            this.initClient(proxyImpl, ep, actualState == null);
            Class<?> serviceClassFinal = cri.getServiceClass();
            ClassLoader theLoader = AccessController.doPrivileged(() -> this.proxyLoader == null ? serviceClassFinal.getClassLoader() : this.proxyLoader);
            Class[] ifaces = new Class[]{Client.class, InvocationHandlerAware.class, Closeable.class, cri.getServiceClass()};
            Client actualClient = (Client)ProxyHelper.getProxy(theLoader, ifaces, proxyImpl);
            proxyImpl.setProxyClient(actualClient);
            this.notifyLifecycleManager(actualClient);
            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.CLIENT_CREATED, actualClient, ep);
            return actualClient;
        }
        catch (IllegalArgumentException ex) {
            String expected;
            String message = ex.getLocalizedMessage();
            if (cri != null && ((expected = cri.getServiceClass().getSimpleName()) + " is not an interface").equals(message)) {
                message = message + "; make sure CGLIB is on the classpath";
            }
            LOG.severe(ex.getClass().getName() + " : " + message);
            throw ex;
        }
        catch (Exception ex) {
            LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    protected ClientProxyImpl createClientProxy(ClassResourceInfo cri, boolean isRoot, ClientState actualState, Object[] varValues) {
        if (actualState == null) {
            return new ClientProxyImpl(URI.create(this.getAddress()), this.proxyLoader, cri, isRoot, this.inheritHeaders, this.getProperties(), varValues);
        }
        return new ClientProxyImpl(actualState, this.proxyLoader, cri, isRoot, this.inheritHeaders, varValues);
    }

    protected ConduitSelector getConduitSelector(Endpoint ep) {
        ConduitSelector cs = this.getConduitSelector();
        if (cs == null) {
            cs = new UpfrontConduitSelector();
        }
        cs.setEndpoint(ep);
        return cs;
    }

    protected void initClient(AbstractClient client, Endpoint ep, boolean addHeaders) {
        if (this.username != null) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName(this.username);
            authPolicy.setPassword(this.password);
            ep.getEndpointInfo().addExtensor(authPolicy);
        }
        client.getConfiguration().setConduitSelector(this.getConduitSelector(ep));
        client.getConfiguration().setBus(this.getBus());
        client.getConfiguration().getOutInterceptors().addAll(this.getOutInterceptors());
        client.getConfiguration().getOutInterceptors().addAll(ep.getOutInterceptors());
        client.getConfiguration().getInInterceptors().addAll(this.getInInterceptors());
        client.getConfiguration().getInInterceptors().addAll(ep.getInInterceptors());
        client.getConfiguration().getInFaultInterceptors().addAll(this.getInFaultInterceptors());
        this.applyFeatures(client);
        if (this.headers != null && addHeaders) {
            client.headers(this.headers);
        }
        ClientProviderFactory factory = ClientProviderFactory.createInstance(this.getBus());
        this.setupFactory(factory, ep);
        Map<String, Object> theProperties = super.getProperties();
        boolean encodeClientParameters = PropertyUtils.isTrue(theProperties, "url.encode.client.parameters");
        if (encodeClientParameters) {
            final String encodeClientParametersList = (String)this.getProperties().get("url.encode.client.parameters.list");
            factory.registerUserProvider(new ParamConverterProvider(){

                @Override
                public <T> ParamConverter<T> getConverter(Class<T> cls, Type t, Annotation[] anns) {
                    if (cls == String.class && AnnotationUtils.getAnnotation(anns, HeaderParam.class) == null && AnnotationUtils.getAnnotation(anns, CookieParam.class) == null) {
                        return new UrlEncodingParamConverter(encodeClientParametersList);
                    }
                    return null;
                }
            });
        }
    }

    protected <C extends Configurable<C>> Configurable<?> getConfigurableFor(C context) {
        return new ConfigurableImpl<C>(context, RuntimeType.CLIENT);
    }

    protected void applyFeatures(AbstractClient client) {
        if (this.getFeatures() != null) {
            this.getFeatures().forEach(feature -> feature.initialize(client.getConfiguration(), this.getBus()));
        }
        HashSet<Object> providers = new HashSet<Object>();
        for (Object provider : this.getProviders()) {
            if (!(provider instanceof Feature)) continue;
            Feature feature2 = (Feature)provider;
            FeatureContextImpl context = new FeatureContextImpl();
            Configurable<?> configurable = this.getConfigurableFor(context);
            Configuration configuration = configurable.getConfiguration();
            Set<Object> registered = configuration.getInstances();
            if (configuration.isRegistered(feature2)) continue;
            configurable.register(feature2);
            HashSet<Object> added = new HashSet<Object>(configuration.getInstances());
            added.remove(feature2);
            added.removeAll(registered);
            providers.addAll(added);
        }
        if (!providers.isEmpty()) {
            this.setProviders(Arrays.asList(providers));
        }
    }

    public void setInitialState(ClientState initialState) {
        this.initialState = initialState;
    }
}

