/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;

class Lifecycle {
    private final BeanManager beanManager;
    private final Bean<?> bean;
    private Object instance;
    private CreationalContext<?> context;

    Lifecycle(BeanManager beanManager, Bean<?> bean) {
        this.beanManager = beanManager;
        this.bean = bean;
    }

    Object create() {
        this.context = this.beanManager.createCreationalContext(this.bean);
        this.instance = this.beanManager.getReference(this.bean, this.bean.getBeanClass(), this.context);
        return this.instance;
    }

    void destroy() {
        if (this.context != null) {
            this.context.release();
            this.instance = null;
            this.context = null;
        }
    }
}

