/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cxf.cdi.ContextResolved;

final class DelegateContextAnnotatedType<X>
implements AnnotatedType<X> {
    private static final Inject INJECT = new InjectLiteral();
    private static final ContextResolved CONTEXT_RESOLVED = ContextResolved.LITERAL;
    private final AnnotatedType<X> original;
    private final Set<AnnotatedField<? super X>> replacedFields;

    DelegateContextAnnotatedType(AnnotatedType<X> original) {
        this.original = original;
        this.replacedFields = this.replaceFields(original);
    }

    private Set<AnnotatedField<? super X>> replaceFields(AnnotatedType<? super X> delegate) {
        return delegate.getFields().stream().map(this::wrap).collect(Collectors.toSet());
    }

    Set<Type> getContextFieldTypes() {
        return this.replacedFields.stream().filter(f -> f.isAnnotationPresent(Context.class) || f.isAnnotationPresent(ContextResolved.class)).map(f -> f.getJavaMember().getAnnotatedType().getType()).collect(Collectors.toSet());
    }

    @Override
    public Class<X> getJavaClass() {
        return this.original.getJavaClass();
    }

    @Override
    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.original.getConstructors();
    }

    @Override
    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.original.getMethods();
    }

    @Override
    public Set<AnnotatedField<? super X>> getFields() {
        return this.replacedFields;
    }

    @Override
    public Type getBaseType() {
        return this.original.getBaseType();
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this.original.getTypeClosure();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.original.getAnnotation(annotationType);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.original.getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.original.isAnnotationPresent(annotationType);
    }

    private AnnotatedField<? super X> wrap(AnnotatedField<? super X> af) {
        if (af.isAnnotationPresent(Context.class)) {
            return new DelegateAnnotatedField(af);
        }
        return af;
    }

    private static final class InjectLiteral
    extends AnnotationLiteral<Inject>
    implements Inject {
        private static final long serialVersionUID = 1L;

        private InjectLiteral() {
        }
    }

    private final class DelegateAnnotatedField<Y>
    implements AnnotatedField<Y> {
        private final AnnotatedField<Y> original;
        private final Set<Annotation> annotationSet;

        private DelegateAnnotatedField(AnnotatedField<Y> delegate) {
            this.original = delegate;
            this.annotationSet = this.processAnnotations(delegate.getAnnotations());
        }

        private Set<Annotation> processAnnotations(Set<Annotation> annotations) {
            LinkedHashSet<Annotation> resultAnnotations = new LinkedHashSet<Annotation>();
            for (Annotation a : annotations) {
                if (a instanceof Context) {
                    resultAnnotations.add(INJECT);
                    resultAnnotations.add(CONTEXT_RESOLVED);
                }
                resultAnnotations.add(a);
            }
            return Collections.unmodifiableSet(resultAnnotations);
        }

        @Override
        public Field getJavaMember() {
            return this.original.getJavaMember();
        }

        @Override
        public boolean isStatic() {
            return this.original.isStatic();
        }

        @Override
        public AnnotatedType<Y> getDeclaringType() {
            return this.original.getDeclaringType();
        }

        @Override
        public Type getBaseType() {
            return this.original.getBaseType();
        }

        @Override
        public Set<Type> getTypeClosure() {
            return this.original.getTypeClosure();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            for (Annotation a : this.annotationSet) {
                if (annotationType != a.annotationType()) continue;
                return (T)a;
            }
            return null;
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.annotationSet;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }
    }
}

