/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.cdi.AbstractCXFBean;
import org.apache.cxf.cdi.ContextResolved;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public class ContextProducerBean
extends AbstractCXFBean<Object>
implements PassivationCapable {
    private final Type type;
    private final Set<Annotation> qualifiers;

    ContextProducerBean(Type type, boolean defaultQualifier) {
        this.type = type;
        this.qualifiers = new HashSet<Annotation>(defaultQualifier ? 2 : 1);
        this.qualifiers.add(ContextResolved.LITERAL);
        if (defaultQualifier) {
            this.qualifiers.add(DEFAULT);
        }
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    public Class<?> getBeanClass() {
        return (Class)this.type;
    }

    @Override
    public Object create(CreationalContext<Object> creationalContext) {
        return this.createContextValue();
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public Set<Type> getTypes() {
        Set<Type> types = super.getTypes();
        types.add(this.type);
        return types;
    }

    @Override
    public String getName() {
        return "CxfContextProducer" + this.type;
    }

    private Object createContextValue() {
        Class contextType;
        Message currentMessage = PhaseInterceptorChain.getCurrentMessage();
        Type genericType = null;
        if (this.type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.type;
            genericType = parameterizedType.getActualTypeArguments()[0];
            contextType = (Class)parameterizedType.getRawType();
        } else {
            contextType = (Class)this.type;
        }
        return JAXRSUtils.createContextValue(currentMessage, genericType, contextType);
    }

    @Override
    public String getId() {
        return this.getName();
    }
}

