/*
 * Decompiled with CFR 0.152.
 */
package jakarta.ws.rs.sse;

import jakarta.ws.rs.sse.SseEventSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Logger;

final class SseFinder {
    private static final Logger LOGGER = Logger.getLogger(SseFinder.class.getName());
    private static final String FACTORY_ID = SseEventSource.Builder.class.getName();
    private static final String SERVICE_ID = "META-INF/services/" + FACTORY_ID;

    static Object find(String defaultClazz) throws ClassNotFoundException {
        String factoryClassName;
        ClassLoader classLoader = SseFinder.getContextClassLoader();
        try {
            Iterator<SseEventSource.Builder> iterator = ServiceLoader.load(SseEventSource.Builder.class).iterator();
            if (iterator.hasNext()) {
                SseEventSource.Builder builder = iterator.next();
                return builder;
            }
            InputStream is = null;
            is = classLoader == null ? ClassLoader.getSystemResourceAsStream(SERVICE_ID) : classLoader.getResourceAsStream(SERVICE_ID);
            if (is == null) {
                String dottedId = SERVICE_ID.replace('$', '.');
                is = classLoader == null ? ClassLoader.getSystemResourceAsStream(dottedId) : classLoader.getResourceAsStream(dottedId);
            }
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return SseFinder.newInstance(factoryClassName, classLoader);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.finest(ex.getMessage());
        }
        try {
            File f = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "jaxrs.properties");
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                factoryClassName = props.getProperty(FACTORY_ID);
                return SseFinder.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception ex) {
            LOGGER.finest(ex.getMessage());
        }
        try {
            String systemProp = System.getProperty(FACTORY_ID);
            if (systemProp != null) {
                return SseFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            LOGGER.finest(se.getMessage());
        }
        if (defaultClazz == null) {
            throw new ClassNotFoundException(FACTORY_ID + " not found", null);
        }
        return SseFinder.newInstance(defaultClazz, classLoader);
    }

    static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> spiClass;
            if (classLoader == null) {
                spiClass = Class.forName(className);
            } else {
                try {
                    spiClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.finest(ex.getMessage());
                    spiClass = Class.forName(className);
                }
            }
            return spiClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ClassNotFoundException(x.getMessage(), x);
        }
    }

    private SseFinder() {
    }
}

