/*
 * Decompiled with CFR 0.152.
 */
package jakarta.ws.rs.sse;

import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseFinder;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public interface SseEventSource
extends AutoCloseable {
    public void register(Consumer<InboundSseEvent> var1);

    public void register(Consumer<InboundSseEvent> var1, Consumer<Throwable> var2);

    public void register(Consumer<InboundSseEvent> var1, Consumer<Throwable> var2, Runnable var3);

    public static Builder target(WebTarget endpoint) {
        return Builder.newBuilder().target(endpoint);
    }

    public void open();

    public boolean isOpen();

    @Override
    default public void close() {
        this.close(5L, TimeUnit.SECONDS);
    }

    public boolean close(long var1, TimeUnit var3);

    public static abstract class Builder {
        public static final String JAXRS_DEFAULT_SSE_BUILDER_PROPERTY = "org.apache.cxf.jaxrs.sse.client.SseEventSourceBuilderImpl";

        protected Builder() {
        }

        static Builder newBuilder() {
            try {
                Object delegate = SseFinder.find(JAXRS_DEFAULT_SSE_BUILDER_PROPERTY);
                if (!(delegate instanceof Builder)) {
                    Class<Builder> pClass = Builder.class;
                    String classnameAsResource = pClass.getName().replace('.', '/') + ".class";
                    ClassLoader loader = pClass.getClassLoader();
                    if (loader == null) {
                        loader = ClassLoader.getSystemClassLoader();
                    }
                    URL targetTypeURL = loader.getResource(classnameAsResource);
                    throw new LinkageError("ClassCastException: attempting to cast" + delegate.getClass().getClassLoader().getResource(classnameAsResource) + " to " + targetTypeURL);
                }
                return (Builder)delegate;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        protected abstract Builder target(WebTarget var1);

        public abstract Builder reconnectingEvery(long var1, TimeUnit var3);

        public abstract SseEventSource build();
    }
}

