/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site;

import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class SiteUtils {
    public static boolean isLink(String href) {
        return StringUtils.isNotBlank((String)href) && (SiteUtils.startsWithAnyIgnoreCase(href, "http:/", "https:/", "ftp:/", "mailto:", "file:/") || href.contains("://"));
    }

    private static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean startsWithAnyIgnoreCase(String string, String ... searchStrings) {
        for (int i = 0; i < searchStrings.length; ++i) {
            String searchString = searchStrings[i];
            if (!SiteUtils.startsWithIgnoreCase(string, searchString)) continue;
            return true;
        }
        return false;
    }

    public static Xpp3Dom getCustomChild(Xpp3Dom custom, String path) {
        String[] elements;
        for (String element : elements = path.split("\\.")) {
            if (custom == null) {
                return null;
            }
            custom = custom.getChild(element);
        }
        return custom;
    }

    public static String getCustomValue(Xpp3Dom custom, String path) {
        return (custom = SiteUtils.getCustomChild(custom, path)) == null ? null : custom.getValue();
    }

    public static String getCustomValue(Xpp3Dom custom, String path, String defaultValue) {
        return (custom = SiteUtils.getCustomChild(custom, path)) == null ? defaultValue : custom.getValue();
    }
}

