/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.util.Objects;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.markup.XmlMarkup;
import org.apache.maven.doxia.sink.impl.SinkAdapter;
import org.apache.maven.doxia.sink.impl.SinkUtils;

public abstract class AbstractXmlSink
extends SinkAdapter
implements XmlMarkup {
    private String nameSpace;
    private boolean firstTag = true;
    private boolean insertNewline = true;

    public void setInsertNewline(boolean insertNewline) {
        this.insertNewline = insertNewline;
    }

    public void setNameSpace(String ns) {
        this.nameSpace = ns;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    protected void writeStartTag(HTML.Tag t) {
        this.writeStartTag(t, null);
    }

    protected void writeStartTag(HTML.Tag t, MutableAttributeSet att) {
        this.writeStartTag(t, att, false);
    }

    protected void writeStartTag(HTML.Tag t, MutableAttributeSet att, boolean isSimpleTag) {
        Objects.requireNonNull(t, "t cannot be null");
        StringBuilder sb = new StringBuilder();
        if (this.insertNewline && t.isBlock() && !this.firstTag) {
            sb.append(EOL);
        }
        this.firstTag = false;
        sb.append('<');
        if (this.nameSpace != null) {
            sb.append(this.nameSpace).append(':');
        }
        sb.append(t.toString());
        sb.append(SinkUtils.getAttributeString(att));
        if (isSimpleTag) {
            sb.append(' ').append('/');
        }
        sb.append('>');
        this.write(sb.toString());
    }

    protected void writeEOL() {
        this.write(EOL);
    }

    protected void writeEndTag(HTML.Tag t) {
        Objects.requireNonNull(t, "t cannot be null");
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append('/');
        if (this.nameSpace != null) {
            sb.append(this.nameSpace).append(':');
        }
        sb.append(t.toString());
        sb.append('>');
        this.write(sb.toString());
    }

    protected void writeSimpleTag(HTML.Tag t) {
        this.writeSimpleTag(t, null);
    }

    protected void writeSimpleTag(HTML.Tag t, MutableAttributeSet att) {
        this.writeStartTag(t, att, true);
    }

    protected abstract void write(String var1);
}

