/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.doxia.markup.Markup;

public class IndexEntry {
    private final IndexEntry parent;
    private String id;
    private boolean hasAnchor;
    private String title;
    private List<IndexEntry> childEntries = new ArrayList<IndexEntry>();
    private final Type type;

    public IndexEntry(String newId) {
        this(null, newId);
    }

    public IndexEntry(IndexEntry newParent, String newId) {
        this(newParent, newId, Type.UNKNOWN);
    }

    public IndexEntry(IndexEntry newParent, String newId, Type type) {
        this.parent = newParent;
        this.id = newId;
        if (this.parent != null) {
            this.parent.childEntries.add(this);
        }
        this.type = type;
    }

    public IndexEntry getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public void setAnchor(boolean hasAnchor) {
        this.hasAnchor = hasAnchor;
    }

    public boolean hasAnchor() {
        return this.hasAnchor;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public List<IndexEntry> getChildEntries() {
        return Collections.unmodifiableList(this.childEntries);
    }

    public void setChildEntries(List<IndexEntry> entries) {
        if (entries == null) {
            this.childEntries = new ArrayList<IndexEntry>();
        }
        this.childEntries = entries;
    }

    public IndexEntry getNextEntry() {
        if (this.parent == null) {
            return null;
        }
        List<IndexEntry> entries = this.parent.getChildEntries();
        int index = entries.indexOf(this);
        if (index + 1 >= entries.size()) {
            return null;
        }
        return entries.get(index + 1);
    }

    public IndexEntry getPrevEntry() {
        if (this.parent == null) {
            return null;
        }
        List<IndexEntry> entries = this.parent.getChildEntries();
        int index = entries.indexOf(this);
        if (index == 0) {
            return null;
        }
        return entries.get(index - 1);
    }

    public IndexEntry getFirstEntry() {
        List<IndexEntry> entries = this.getChildEntries();
        if (entries.size() == 0) {
            return null;
        }
        return entries.get(0);
    }

    public IndexEntry getLastEntry() {
        List<IndexEntry> entries = this.getChildEntries();
        if (entries.size() == 0) {
            return null;
        }
        return entries.get(entries.size() - 1);
    }

    public IndexEntry getRootEntry() {
        List<IndexEntry> entries = this.getChildEntries();
        if (entries.size() == 0) {
            return null;
        }
        if (entries.size() > 1) {
            throw new IllegalStateException("This index has more than one root entry");
        }
        return entries.get(0);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        StringBuilder message = new StringBuilder();
        message.append("Id: ").append(this.id);
        if (this.title != null && !this.title.isEmpty()) {
            message.append(", title: ").append(this.title);
        }
        message.append(Markup.EOL);
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            indent.append(" ");
        }
        for (IndexEntry entry : this.getChildEntries()) {
            message.append((CharSequence)indent).append(entry.toString(depth + 1));
        }
        return message.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.childEntries, this.hasAnchor, this.id, this.parent, this.title, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexEntry other = (IndexEntry)obj;
        return Objects.equals(this.childEntries, other.childEntries) && this.hasAnchor == other.hasAnchor && Objects.equals(this.id, other.id) && Objects.equals(this.parent, other.parent) && Objects.equals(this.title, other.title) && this.type == other.type;
    }

    public static enum Type {
        UNKNOWN,
        SECTION_1(1),
        SECTION_2(2),
        SECTION_3(3),
        SECTION_4(4),
        SECTION_5(5),
        SECTION_6(6),
        DEFINED_TERM,
        FIGURE,
        TABLE;

        private final int sectionLevel;

        private Type() {
            this(-1);
        }

        private Type(int sectionLevel) {
            this.sectionLevel = sectionLevel;
        }

        static Type fromSectionLevel(int level) {
            if (level < 1 || level > 6) {
                throw new IllegalArgumentException("Level must be between 1 and 6 but is " + level);
            }
            return Arrays.stream(Type.values()).filter(t -> level == t.sectionLevel).findAny().orElseThrow(() -> new IllegalStateException("Could not find enum for sectionLevel " + level));
        }
    }
}

