/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml.decoration.render;

import java.io.File;
import org.codehaus.plexus.util.PathTool;

public class RenderingContext {
    private final File basedir;
    private final String inputName;
    private final String outputName;
    private final String parserId;
    private final String relativePath;

    public RenderingContext(File basedir, String document) {
        this(basedir, document, null);
    }

    public RenderingContext(File basedir, String document, String parserId) {
        this.basedir = basedir;
        this.outputName = document.substring(0, document.lastIndexOf(".")).replace('\\', '/') + ".html";
        this.relativePath = PathTool.getRelativePath((String)basedir.getPath(), (String)new File(basedir, document).getPath());
        this.inputName = document;
        this.parserId = parserId;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String getInputName() {
        return this.inputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getParserId() {
        return this.parserId;
    }

    public String getRelativePath() {
        return this.relativePath;
    }
}

