/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.latex;

import java.io.Writer;
import org.apache.maven.doxia.sink.SinkAdapter;
import org.apache.maven.doxia.util.LineBreaker;

public class LatexSink
extends SinkAdapter {
    private static final String EOL = System.getProperty("line.separator");
    private LineBreaker out;
    private String preamble;
    private boolean titleFlag;
    private int numberedListNesting;
    private boolean verbatimFlag;
    private boolean boxFlag;
    private boolean figureFlag;
    private boolean tableFlag;
    private boolean gridFlag;
    private int[] cellJustif;
    private int cellCount;
    private static final String defaultPreamble = "\\newcommand{\\ptitle}[1]{\\title{#1}}" + EOL + "\\newcommand{\\pauthor}[1]{\\author{#1}}" + EOL + "\\newcommand{\\pdate}[1]{\\date{#1}}" + EOL + "\\newcommand{\\pmaketitle}{\\maketitle}" + EOL + "\\newcommand{\\psectioni}[1]{\\section{#1}}" + EOL + "\\newcommand{\\psectionii}[1]{\\subsection{#1}}" + EOL + "\\newcommand{\\psectioniii}[1]{\\subsubsection{#1}}" + EOL + "\\newcommand{\\psectioniv}[1]{\\paragraph{#1}}" + EOL + "\\newcommand{\\psectionv}[1]{\\subparagraph{#1}}" + EOL + "\\newenvironment{plist}{\\begin{itemize}}{\\end{itemize}}" + EOL + "\\newenvironment{pnumberedlist}{\\begin{enumerate}}{\\end{enumerate}}" + EOL + "\\newcommand{\\pdef}[1]{\\textbf{#1}\\hfill}" + EOL + "\\newenvironment{pdefinitionlist}" + EOL + "{\\begin{list}{}{\\settowidth{\\labelwidth}{\\textbf{999.}}" + EOL + "                \\setlength{\\leftmargin}{\\labelwidth}" + EOL + "                \\addtolength{\\leftmargin}{\\labelsep}" + EOL + "                \\renewcommand{\\makelabel}{\\pdef}}}" + EOL + "{\\end{list}}" + EOL + "\\newenvironment{pfigure}{\\begin{center}}{\\end{center}}" + EOL + "\\newcommand{\\pfiguregraphics}[1]{\\includegraphics{#1.eps}}" + EOL + "\\newcommand{\\pfigurecaption}[1]{\\\\ \\vspace{\\pparskipamount}" + EOL + "                                \\textit{#1}}" + EOL + "\\newenvironment{ptable}{\\begin{center}}{\\end{center}}" + EOL + "\\newenvironment{ptablerows}[1]{\\begin{tabular}{#1}}{\\end{tabular}}" + EOL + "\\newenvironment{pcell}[1]{\\begin{tabular}[t]{#1}}{\\end{tabular}}" + EOL + "\\newcommand{\\ptablecaption}[1]{\\\\ \\vspace{\\pparskipamount}" + EOL + "                               \\textit{#1}}" + EOL + "\\newenvironment{pverbatim}{\\begin{small}}{\\end{small}}" + EOL + "\\newsavebox{\\pbox}" + EOL + "\\newenvironment{pverbatimbox}" + EOL + "{\\begin{lrbox}{\\pbox}\\begin{minipage}{\\linewidth}\\begin{small}}" + EOL + "{\\end{small}\\end{minipage}\\end{lrbox}\\fbox{\\usebox{\\pbox}}}" + EOL + "\\newcommand{\\phorizontalrule}{\\begin{center}" + EOL + "                              \\rule[0.5ex]{\\linewidth}{1pt}" + EOL + "                              \\end{center}}" + EOL + "\\newcommand{\\panchor}[1]{\\textcolor{panchorcolor}{#1}}" + EOL + "\\newcommand{\\plink}[1]{\\textcolor{plinkcolor}{#1}}" + EOL + "\\newcommand{\\pitalic}[1]{\\textit{#1}}" + EOL + "\\newcommand{\\pbold}[1]{\\textbf{#1}}" + EOL + "\\newcommand{\\pmonospaced}[1]{\\texttt{\\small #1}}" + EOL + EOL + "\\documentclass[a4paper]{article}" + EOL + "\\usepackage{a4wide}" + EOL + "\\usepackage{color}" + EOL + "\\usepackage{graphics}" + EOL + "\\usepackage{times}" + EOL + "\\usepackage[latin1]{inputenc}" + EOL + "\\usepackage[T1]{fontenc}" + EOL + EOL + "\\pagestyle{plain}" + EOL + EOL + "\\definecolor{plinkcolor}{rgb}{0,0,0.54}" + EOL + "\\definecolor{panchorcolor}{rgb}{0.54,0,0}" + EOL + EOL + "\\newlength{\\pparskipamount}" + EOL + "\\setlength{\\pparskipamount}{1ex}" + EOL + "\\setlength{\\parindent}{0pt}" + EOL + "\\setlength{\\parskip}{\\pparskipamount}" + EOL + EOL;

    public LatexSink(Writer out) {
        this(out, defaultPreamble);
    }

    public LatexSink(Writer out, String preamble) {
        this.out = new LineBreaker(out);
        this.setPreamble(preamble);
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public String getPreamble() {
        return this.preamble;
    }

    public void head() {
        this.titleFlag = false;
        this.numberedListNesting = 0;
        this.verbatimFlag = false;
        this.boxFlag = false;
        this.figureFlag = false;
        this.tableFlag = false;
        this.gridFlag = false;
        this.cellJustif = null;
        this.cellCount = 0;
        this.markup(this.preamble);
        this.markup("\\begin{document}" + EOL + EOL);
    }

    public void body() {
        if (this.titleFlag) {
            this.titleFlag = false;
            this.markup("\\pmaketitle" + EOL + EOL);
        }
    }

    public void body_() {
        this.markup("\\end{document}" + EOL + EOL);
        this.out.flush();
    }

    public void section1() {
        this.markup("\\psectioni{");
    }

    public void section2() {
        this.markup("\\psectionii{");
    }

    public void section3() {
        this.markup("\\psectioniii{");
    }

    public void section4() {
        this.markup("\\psectioniv{");
    }

    public void section5() {
        this.markup("\\psectionv{");
    }

    public void list() {
        this.markup("\\begin{plist}" + EOL + EOL);
    }

    public void list_() {
        this.markup("\\end{plist}" + EOL + EOL);
    }

    public void listItem() {
        this.markup("\\item{} ");
    }

    public void numberedList(int numbering) {
        String style;
        String counter;
        ++this.numberedListNesting;
        switch (this.numberedListNesting) {
            case 1: {
                counter = "enumi";
                break;
            }
            case 2: {
                counter = "enumii";
                break;
            }
            case 3: {
                counter = "enumiii";
                break;
            }
            default: {
                counter = "enumiv";
            }
        }
        switch (numbering) {
            case 2: {
                style = "Alph";
                break;
            }
            case 1: {
                style = "alph";
                break;
            }
            case 4: {
                style = "Roman";
                break;
            }
            case 3: {
                style = "roman";
                break;
            }
            default: {
                style = "arabic";
            }
        }
        this.markup("\\begin{pnumberedlist}" + EOL);
        this.markup("\\renewcommand{\\the" + counter + "}{\\" + style + "{" + counter + "}}" + EOL + EOL);
    }

    public void numberedList_() {
        this.markup("\\end{pnumberedlist}" + EOL + EOL);
        --this.numberedListNesting;
    }

    public void numberedListItem() {
        this.markup("\\item{} ");
    }

    public void definitionList() {
        this.markup("\\begin{pdefinitionlist}" + EOL + EOL);
    }

    public void definitionList_() {
        this.markup("\\end{pdefinitionlist}" + EOL + EOL);
    }

    public void figure() {
        this.figureFlag = true;
        this.markup("\\begin{pfigure}" + EOL);
    }

    public void figure_() {
        this.markup("\\end{pfigure}" + EOL + EOL);
        this.figureFlag = false;
    }

    public void table() {
        this.tableFlag = true;
        this.markup("\\begin{ptable}" + EOL);
    }

    public void table_() {
        this.markup("\\end{ptable}" + EOL + EOL);
        this.tableFlag = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        StringBuffer justif = new StringBuffer();
        block5: for (int i = 0; i < justification.length; ++i) {
            if (grid) {
                justif.append('|');
            }
            switch (justification[i]) {
                case 0: {
                    justif.append('c');
                    continue block5;
                }
                case 1: {
                    justif.append('l');
                    continue block5;
                }
                case 2: {
                    justif.append('r');
                }
            }
        }
        if (grid) {
            justif.append('|');
        }
        this.markup("\\begin{ptablerows}{" + justif.toString() + "}" + EOL);
        if (grid) {
            this.markup("\\hline" + EOL);
        }
        this.gridFlag = grid;
        this.cellJustif = justification;
    }

    public void tableRows_() {
        this.markup("\\end{ptablerows}" + EOL);
        this.gridFlag = false;
        this.cellJustif = null;
    }

    public void tableRow() {
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.markup("\\\\" + EOL);
        if (this.gridFlag) {
            this.markup("\\hline" + EOL);
        }
        this.cellCount = 0;
    }

    public void title() {
        this.titleFlag = true;
        this.markup("\\ptitle{");
    }

    public void title_() {
        this.markup("}" + EOL);
    }

    public void author() {
        this.markup("\\pauthor{");
    }

    public void author_() {
        this.markup("}" + EOL);
    }

    public void date() {
        this.markup("\\pdate{");
    }

    public void date_() {
        this.markup("}" + EOL);
    }

    public void sectionTitle_() {
        this.markup("}" + EOL + EOL);
    }

    public void paragraph_() {
        this.markup(EOL + EOL);
    }

    public void verbatim(boolean boxed) {
        if (boxed) {
            this.markup("\\begin{pverbatimbox}" + EOL);
        } else {
            this.markup("\\begin{pverbatim}" + EOL);
        }
        this.markup("\\begin{verbatim}" + EOL);
        this.verbatimFlag = true;
        this.boxFlag = boxed;
    }

    public void verbatim_() {
        this.markup(EOL + "\\end{verbatim}" + EOL);
        if (this.boxFlag) {
            this.markup("\\end{pverbatimbox}" + EOL + EOL);
        } else {
            this.markup("\\end{pverbatim}" + EOL + EOL);
        }
        this.verbatimFlag = false;
        this.boxFlag = false;
    }

    public void definedTerm() {
        this.markup("\\item[\\mbox{");
    }

    public void definedTerm_() {
        this.markup("}] ");
    }

    public void figureCaption() {
        this.markup("\\pfigurecaption{");
    }

    public void figureCaption_() {
        this.markup("}" + EOL);
    }

    public void tableCell() {
        char justif;
        if (this.cellCount > 0) {
            this.markup(" &" + EOL);
        }
        switch (this.cellJustif[this.cellCount]) {
            case 1: {
                justif = 'l';
                break;
            }
            case 2: {
                justif = 'r';
                break;
            }
            default: {
                justif = 'c';
            }
        }
        this.markup("\\begin{pcell}{" + justif + "}");
    }

    public void tableCell_() {
        this.markup("\\end{pcell}");
        ++this.cellCount;
    }

    public void tableCaption() {
        this.markup("\\ptablecaption{");
    }

    public void tableCaption_() {
        this.markup("}" + EOL);
    }

    public void figureGraphics(String name) {
        this.markup("\\pfiguregraphics{" + name + "}" + EOL);
    }

    public void horizontalRule() {
        this.markup("\\phorizontalrule" + EOL + EOL);
    }

    public void pageBreak() {
        this.markup("\\newpage" + EOL + EOL);
    }

    public void anchor(String name) {
        this.markup("\\panchor{");
    }

    public void anchor_() {
        this.markup("}");
    }

    public void link(String name) {
        this.markup("\\plink{");
    }

    public void link_() {
        this.markup("}");
    }

    public void italic() {
        this.markup("\\pitalic{");
    }

    public void italic_() {
        this.markup("}");
    }

    public void bold() {
        this.markup("\\pbold{");
    }

    public void bold_() {
        this.markup("}");
    }

    public void monospaced() {
        this.markup("\\pmonospaced{");
    }

    public void monospaced_() {
        this.markup("}");
    }

    public void lineBreak() {
        this.markup(this.figureFlag || this.tableFlag || this.titleFlag ? "\\\\" + EOL : "\\newline" + EOL);
    }

    public void nonBreakingSpace() {
        this.markup("~");
    }

    public void text(String text) {
        if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    protected void markup(String text) {
        this.out.write(text, true);
    }

    protected void content(String text) {
        this.out.write(LatexSink.escaped(text), false);
    }

    protected void verbatimContent(String text) {
        this.out.write(text, true);
    }

    protected static String escaped(String text) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block14: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '-': 
                case '<': 
                case '>': {
                    buffer.append("\\symbol{" + c + "}");
                    continue block14;
                }
                case '~': {
                    buffer.append("\\textasciitilde ");
                    continue block14;
                }
                case '^': {
                    buffer.append("\\textasciicircum ");
                    continue block14;
                }
                case '|': {
                    buffer.append("\\textbar ");
                    continue block14;
                }
                case '\\': {
                    buffer.append("\\textbackslash ");
                    continue block14;
                }
                case '$': {
                    buffer.append("\\$");
                    continue block14;
                }
                case '&': {
                    buffer.append("\\&");
                    continue block14;
                }
                case '%': {
                    buffer.append("\\%");
                    continue block14;
                }
                case '#': {
                    buffer.append("\\#");
                    continue block14;
                }
                case '{': {
                    buffer.append("\\{");
                    continue block14;
                }
                case '}': {
                    buffer.append("\\}");
                    continue block14;
                }
                case '_': {
                    buffer.append("\\_");
                    continue block14;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }
}

