/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.ConfigurationMonitor;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.config.ReliabilityStrategyFactory;

public class FileConfigurationMonitor
implements ConfigurationMonitor {
    private static final int MASK = 15;
    static final int MIN_INTERVAL = 5;
    private final File file;
    private volatile long lastModified;
    private final List<ConfigurationListener> listeners;
    private final long intervalNano;
    private volatile long nextCheck;
    private final AtomicInteger counter = new AtomicInteger(0);
    private static final Lock LOCK = new ReentrantLock();
    private final Reconfigurable reconfigurable;

    public FileConfigurationMonitor(Reconfigurable reconfigurable, File file, List<ConfigurationListener> listeners, int intervalSeconds) {
        this.reconfigurable = reconfigurable;
        this.file = file;
        this.lastModified = file.lastModified();
        this.listeners = listeners;
        this.intervalNano = TimeUnit.SECONDS.toNanos(Math.max(intervalSeconds, 5));
        this.nextCheck = System.nanoTime() + this.intervalNano;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConfiguration() {
        long current;
        if ((this.counter.incrementAndGet() & 0xF) == 0 && (current = System.nanoTime()) - this.nextCheck >= 0L) {
            LOCK.lock();
            try {
                this.nextCheck = current + this.intervalNano;
                long currentLastModified = this.file.lastModified();
                if (currentLastModified > this.lastModified) {
                    this.lastModified = currentLastModified;
                    for (ConfigurationListener listener : this.listeners) {
                        Thread thread = new Thread(new ReconfigurationWorker(listener, this.reconfigurable));
                        thread.setDaemon(true);
                        thread.start();
                    }
                }
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    @Override
    public ReliabilityStrategy getReliabilityStrategy(LoggerConfig loggerConfig) {
        return ReliabilityStrategyFactory.getReliabilityStrategy(loggerConfig);
    }

    private static class ReconfigurationWorker
    implements Runnable {
        private final ConfigurationListener listener;
        private final Reconfigurable reconfigurable;

        public ReconfigurationWorker(ConfigurationListener listener, Reconfigurable reconfigurable) {
            this.listener = listener;
            this.reconfigurable = reconfigurable;
        }

        @Override
        public void run() {
            this.listener.onChange(this.reconfigurable);
        }
    }
}

