/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.test.ListStatusListener;
import org.apache.logging.log4j.test.junit.ExtensionContextAnchor;
import org.apache.logging.log4j.test.junit.TypeBasedParameterResolver;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

class StatusLoggerExtension
extends TypeBasedParameterResolver<ListStatusListener>
implements BeforeEachCallback,
TestExecutionExceptionHandler {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final StatusConsoleListener CONSOLE_LISTENER = new StatusConsoleListener(Level.ALL);
    private static final Object KEY = ListStatusListener.class;

    public StatusLoggerExtension() {
        super((Type)((Object)ListStatusListener.class));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ListStatusListenerHolder holder = new ListStatusListenerHolder(context);
        ExtensionContextAnchor.setAttribute(KEY, holder, context);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        ListStatusListener statusListener = this.resolveParameter(null, context);
        statusListener.getStatusData().forEach(arg_0 -> ((StatusConsoleListener)CONSOLE_LISTENER).log(arg_0));
        throw throwable;
    }

    @Override
    public ListStatusListener resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ListStatusListenerHolder holder = ExtensionContextAnchor.getAttribute(KEY, ListStatusListenerHolder.class, extensionContext);
        return holder.getStatusListener();
    }

    private static class JUnitListStatusListener
    implements ListStatusListener {
        private final ExtensionContext context;
        private final List<StatusData> statusData = Collections.synchronizedList(new ArrayList());

        public JUnitListStatusListener(ExtensionContext context) {
            this.context = context;
        }

        public void log(StatusData data) {
            if (this.context.equals(ExtensionContextAnchor.getContext())) {
                this.statusData.add(data);
            }
        }

        public Level getStatusLevel() {
            return Level.DEBUG;
        }

        public void close() throws IOException {
        }

        @Override
        public Stream<StatusData> getStatusData() {
            return this.statusData.stream();
        }
    }

    private static class ListStatusListenerHolder
    implements ExtensionContext.Store.CloseableResource {
        private final ListStatusListener statusListener;

        public ListStatusListenerHolder(ExtensionContext context) {
            this.statusListener = new JUnitListStatusListener(context);
            LOGGER.registerListener((StatusListener)this.statusListener);
        }

        public ListStatusListener getStatusListener() {
            return this.statusListener;
        }

        public void close() throws Throwable {
            LOGGER.removeListener((StatusListener)this.statusListener);
        }
    }
}

