/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.utils;

import java.util.HashMap;
import java.util.List;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.message.parser.ServiceMethod;
import org.apache.linkis.message.scheduler.MethodExecuteWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class MessageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageUtils.class);

    public static <T> T getBean(Class<T> tClass) {
        Object t = null;
        ApplicationContext applicationContext = DataWorkCloudApplication.getApplicationContext();
        if (applicationContext != null) {
            try {
                t = applicationContext.getBean(tClass);
            }
            catch (NoSuchBeanDefinitionException e) {
                LOGGER.warn(String.format("can not get bean from spring ioc:%s", tClass.getName()));
            }
        }
        return (T)t;
    }

    public static boolean isAssignableFrom(String supperClassName, String className) {
        try {
            return Class.forName(supperClassName).isAssignableFrom(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("class not found", (Throwable)e);
            return false;
        }
    }

    public static boolean orderIsMin(MethodExecuteWrapper methodExecuteWrapper, List<MethodExecuteWrapper> methodExecuteWrappers) {
        for (MethodExecuteWrapper tmp : methodExecuteWrappers) {
            if (tmp.getOrder() >= methodExecuteWrapper.getOrder()) continue;
            return false;
        }
        return true;
    }

    public static boolean orderIsLast(int order, List<ServiceMethod> serviceMethods) {
        if (order == Integer.MAX_VALUE) {
            return true;
        }
        for (ServiceMethod serviceMethod : serviceMethods) {
            if (serviceMethod.getOrder() <= order) continue;
            return false;
        }
        return false;
    }

    public static Integer repeatOrder(List<ServiceMethod> serviceMethods) {
        HashMap<Integer, Integer> tmp = new HashMap<Integer, Integer>();
        for (ServiceMethod serviceMethod : serviceMethods) {
            int order = serviceMethod.getOrder();
            if (tmp.get(order) == null) {
                tmp.put(order, order);
                continue;
            }
            return order;
        }
        return null;
    }
}

