/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.scheduler;

import org.apache.linkis.message.builder.MessageJob;
import org.apache.linkis.message.builder.MessageJobListener;
import org.apache.linkis.message.conf.MessageSchedulerConf;
import org.apache.linkis.message.scheduler.MessageExecutorExecutionManager;
import org.apache.linkis.message.scheduler.MessageScheduler;
import org.apache.linkis.scheduler.Scheduler;
import org.apache.linkis.scheduler.SchedulerContext;
import org.apache.linkis.scheduler.executer.ExecutorManager;
import org.apache.linkis.scheduler.listener.JobListener;
import org.apache.linkis.scheduler.queue.ConsumerManager;
import org.apache.linkis.scheduler.queue.GroupFactory;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.SchedulerEvent;
import org.apache.linkis.scheduler.queue.fifoqueue.FIFOGroupFactory;
import org.apache.linkis.scheduler.queue.parallelqueue.ParallelConsumerManager;
import org.apache.linkis.scheduler.queue.parallelqueue.ParallelScheduler;
import org.apache.linkis.scheduler.queue.parallelqueue.ParallelSchedulerContextImpl;

public class DefaultMessageScheduler
implements MessageScheduler {
    private static final int MAX_ASK_EXECUTOR_TIMES = 1000;
    private final Scheduler linkisScheduler;
    private static final String GROUP_NAME = "message-scheduler";

    public Scheduler getLinkisScheduler() {
        return this.linkisScheduler;
    }

    public DefaultMessageScheduler() {
        this(null);
    }

    public DefaultMessageScheduler(GroupFactory groupFactory) {
        ParallelSchedulerContextImpl schedulerContext = new ParallelSchedulerContextImpl(MessageSchedulerConf.MAX_PARALLELISM_USER.intValue());
        ParallelConsumerManager parallelConsumerManager = new ParallelConsumerManager(MessageSchedulerConf.MAX_PARALLELISM_CONSUMERS.intValue(), "RpcMessageScheduler");
        schedulerContext.setConsumerManager((ConsumerManager)parallelConsumerManager);
        MessageExecutorExecutionManager messageExecutorExecutionManager = new MessageExecutorExecutionManager(parallelConsumerManager.getOrCreateExecutorService());
        schedulerContext.setExecutorManager((ExecutorManager)messageExecutorExecutionManager);
        if (groupFactory != null) {
            schedulerContext.setGroupFactory(groupFactory);
        } else {
            groupFactory = schedulerContext.getOrCreateGroupFactory();
            if (groupFactory instanceof FIFOGroupFactory) {
                FIFOGroupFactory fifoGroupFactory = (FIFOGroupFactory)groupFactory;
                fifoGroupFactory.setDefaultMaxRunningJobs(MessageSchedulerConf.MAX_RUNNING_JOB.intValue());
                fifoGroupFactory.setDefaultMaxAskExecutorTimes(1000L);
                fifoGroupFactory.setDefaultMaxCapacity(MessageSchedulerConf.MAX_QUEUE_CAPACITY.intValue());
            }
        }
        this.linkisScheduler = new ParallelScheduler((SchedulerContext)schedulerContext);
        this.linkisScheduler.init();
    }

    @Override
    public void submit(MessageJob messageJob) {
        if (messageJob instanceof Job) {
            if (null == messageJob.getMethodContext().getSender()) {
                ((Job)messageJob).setId(GROUP_NAME);
            } else {
                ((Job)messageJob).setId(messageJob.getMethodContext().getSender().toString());
            }
            ((Job)messageJob).setJobListener((JobListener)new MessageJobListener());
            this.linkisScheduler.submit((SchedulerEvent)((Job)messageJob));
        }
    }
}

