/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.scheduler;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.linkis.message.builder.MessageJob;
import org.apache.linkis.message.exception.MessageWarnException;
import org.apache.linkis.message.scheduler.AbstractMessageExecutor;
import org.apache.linkis.protocol.engine.EngineState;
import org.apache.linkis.rpc.MessageErrorConstants;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteRequest;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.Executor;
import org.apache.linkis.scheduler.executer.ExecutorInfo;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.scheduler.queue.SchedulerEvent;

public class DefaultMessageExecutor
extends AbstractMessageExecutor
implements Executor {
    private final ExecutorService executorService;
    private final SchedulerEvent event;

    public DefaultMessageExecutor(SchedulerEvent event, ExecutorService executorService) {
        this.event = event;
        this.executorService = executorService;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public long getId() {
        return 0L;
    }

    public ExecuteResponse execute(ExecuteRequest executeRequest) {
        if (this.event instanceof MessageJob) {
            try {
                this.run((MessageJob)this.event);
                return new SuccessExecuteResponse();
            }
            catch (InterruptedException ie) {
                this.logger().error("message job execution interrupted", (Throwable)ie);
                return new ErrorExecuteResponse("message job execution interrupted", (Throwable)ie);
            }
            catch (MessageWarnException mwe) {
                this.logger().error("method call normal error return");
                return new ErrorExecuteResponse("method call failed", (Throwable)((Object)mwe));
            }
            catch (Throwable t) {
                this.logger().debug("unexpected error occur", t);
                return new ErrorExecuteResponse("unexpected error", t);
            }
        }
        MessageWarnException eventNotMatchError = new MessageWarnException(MessageErrorConstants.MESSAGE_ERROR(), "event is not instance of MessageJob");
        return new ErrorExecuteResponse("event is not instance of MessageJob", (Throwable)((Object)eventNotMatchError));
    }

    public EngineState state() {
        return null;
    }

    public ExecutorInfo getExecutorInfo() {
        return new ExecutorInfo(0L, null);
    }

    public void close() throws IOException {
    }
}

