/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.registry;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.linkis.message.annotation.Implicit;
import org.apache.linkis.message.conf.MessageSchedulerConf;
import org.apache.linkis.message.context.AbstractMessageSchedulerContext;
import org.apache.linkis.message.registry.AbstractImplicitRegistry;
import org.apache.linkis.message.utils.MessageUtils;

public class SpringImplicitRegistry
extends AbstractImplicitRegistry {
    public SpringImplicitRegistry(AbstractMessageSchedulerContext context) {
        super(context);
        Set implicitMethods = MessageSchedulerConf.REFLECTIONS.getMethodsAnnotatedWith(Implicit.class);
        Set implicitClasses = implicitMethods.stream().map(Method::getDeclaringClass).collect(Collectors.toSet());
        for (Class implicitClass : implicitClasses) {
            Object bean = MessageUtils.getBean(implicitClass);
            if (bean == null) {
                try {
                    bean = implicitClass.newInstance();
                }
                catch (Throwable t) {
                    this.logger().warn(String.format("reflection failed to create object %s", implicitClass.getName()));
                }
            }
            if (bean == null) continue;
            this.register(bean);
        }
    }
}

