/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.registry;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.linkis.common.utils.JavaLog;
import org.apache.linkis.message.context.AbstractMessageSchedulerContext;
import org.apache.linkis.message.parser.ServiceMethod;
import org.apache.linkis.message.parser.ServiceParser;
import org.apache.linkis.message.registry.ServiceRegistry;
import org.springframework.aop.support.AopUtils;

public abstract class AbstractServiceRegistry
extends JavaLog
implements ServiceRegistry {
    public final Interner<String> lock = Interners.newWeakInterner();
    private final Map<String, List<ServiceMethod>> serviceMethodCache = new ConcurrentHashMap<String, List<ServiceMethod>>();
    private final Map<String, Object> registedServieMap = new ConcurrentHashMap<String, Object>();
    private final AbstractMessageSchedulerContext context;

    public AbstractServiceRegistry(AbstractMessageSchedulerContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Object service) {
        String serviceName = AopUtils.getTargetClass((Object)service).getName();
        String string = (String)this.lock.intern((Object)serviceName);
        synchronized (string) {
            Object o = this.registedServieMap.get(serviceName);
            if (o != null) {
                return;
            }
            ServiceParser serviceParser = this.context.getservieParser();
            Map<String, List<ServiceMethod>> serviceMethods = serviceParser.parse(service);
            serviceMethods.forEach(this::register);
            this.registedServieMap.put(serviceName, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(String key, List<ServiceMethod> serviceMethods) {
        String string = (String)this.lock.intern((Object)key);
        synchronized (string) {
            this.refreshServiceMethodCache(key, serviceMethods);
        }
    }

    private void refreshServiceMethodCache(String key, List<ServiceMethod> serviceMethods) {
        this.serviceMethodCache.computeIfAbsent(key, k -> new ArrayList()).addAll(serviceMethods);
    }

    public Map<String, List<ServiceMethod>> getServiceMethodCache() {
        return this.serviceMethodCache;
    }
}

