/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.registry;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.linkis.common.utils.JavaLog;
import org.apache.linkis.message.context.AbstractMessageSchedulerContext;
import org.apache.linkis.message.parser.ImplicitMethod;
import org.apache.linkis.message.registry.ImplicitRegistry;

public abstract class AbstractImplicitRegistry
extends JavaLog
implements ImplicitRegistry {
    private final AbstractMessageSchedulerContext context;
    private final Map<String, List<ImplicitMethod>> implicitMethodCache = new ConcurrentHashMap<String, List<ImplicitMethod>>();
    public final Interner<String> lock = Interners.newWeakInterner();
    private final Map<String, Object> registedImplicitObjectMap = new ConcurrentHashMap<String, Object>();

    public AbstractImplicitRegistry(AbstractMessageSchedulerContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Object implicitObject) {
        String implicitObjectName = implicitObject.getClass().getName();
        String string = (String)this.lock.intern((Object)implicitObjectName);
        synchronized (string) {
            Object o = this.registedImplicitObjectMap.get(implicitObjectName);
            if (o != null) {
                return;
            }
            Map<String, List<ImplicitMethod>> implicitMethods = this.context.getImplicitParser().parse(implicitObject);
            implicitMethods.forEach(this::refreshImplicitMethodCache);
            this.registedImplicitObjectMap.put(implicitObjectName, implicitObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshImplicitMethodCache(String key, List<ImplicitMethod> implicitMethods) {
        String string = (String)this.lock.intern((Object)key);
        synchronized (string) {
            List implicitMethodsOld = this.implicitMethodCache.computeIfAbsent(key, k -> new ArrayList());
            for (ImplicitMethod implicitMethod : implicitMethods) {
                if (this.isImplicitRepeat(new ArrayList<ImplicitMethod>(implicitMethodsOld), implicitMethod)) continue;
                implicitMethodsOld.add(implicitMethod);
            }
        }
    }

    private boolean isImplicitRepeat(List<ImplicitMethod> implicitMethodsOld, ImplicitMethod implicitMethod) {
        return implicitMethodsOld.stream().anyMatch(im -> im.getImplicitObject() == implicitMethod.getImplicitObject() && im.getInput().equals(implicitMethod.getInput()));
    }

    public Map<String, List<ImplicitMethod>> getImplicitMethodCache() {
        return this.implicitMethodCache;
    }
}

