/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.publisher;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.linkis.common.utils.JavaLog;
import org.apache.linkis.message.builder.DefaultServiceMethodContext;
import org.apache.linkis.message.builder.MessageJob;
import org.apache.linkis.message.builder.ServiceMethodContext;
import org.apache.linkis.message.context.AbstractMessageSchedulerContext;
import org.apache.linkis.message.exception.MessageWarnException;
import org.apache.linkis.message.parser.ImplicitMethod;
import org.apache.linkis.message.parser.ServiceMethod;
import org.apache.linkis.message.publisher.MessagePublisher;
import org.apache.linkis.message.scheduler.MethodExecuteWrapper;
import org.apache.linkis.message.utils.MessageUtils;
import org.apache.linkis.protocol.message.RequestProtocol;
import org.apache.linkis.rpc.MessageErrorConstants;

public abstract class AbstractMessagePublisher
extends JavaLog
implements MessagePublisher {
    private AbstractMessageSchedulerContext context;
    private final Map<String, Map<String, List<ServiceMethod>>> protocolServiceMethodCache = new ConcurrentHashMap<String, Map<String, List<ServiceMethod>>>();

    public AbstractMessagePublisher(AbstractMessageSchedulerContext context) {
        this.context = context;
    }

    public void setContext(AbstractMessageSchedulerContext context) {
        this.context = context;
    }

    @Override
    public MessageJob publish(RequestProtocol requestProtocol) {
        return this.publish(requestProtocol, new DefaultServiceMethodContext());
    }

    @Override
    public MessageJob publish(RequestProtocol requestProtocol, ServiceMethodContext serviceMethodContext) {
        this.logger().debug(String.format("receive request:%s", requestProtocol.getClass().getName()));
        serviceMethodContext.putIfAbsent("_context_", this.context);
        Map<String, List<MethodExecuteWrapper>> methodExecuteWrappers = this.getMethodExecuteWrappers(requestProtocol);
        MessageJob messageJob = this.context.getJobBuilder().of().with(serviceMethodContext).with(requestProtocol).with(this.context).with(methodExecuteWrappers).build();
        this.context.getScheduler().submit(messageJob);
        return messageJob;
    }

    private Map<String, List<MethodExecuteWrapper>> getMethodExecuteWrappers(RequestProtocol requestProtocol) {
        String protocolName = requestProtocol.getClass().getName();
        Map<String, List<ServiceMethod>> protocolServiceMethods = this.protocolServiceMethodCache.get(protocolName);
        if (protocolServiceMethods == null) {
            Map<String, List<ServiceMethod>> serviceMethodCache = this.context.getServiceRegistry().getServiceMethodCache();
            Map<String, List<ImplicitMethod>> implicitMethodCache = this.context.getImplicitRegistry().getImplicitMethodCache();
            Map<String, List> serviceMatchs = serviceMethodCache.entrySet().stream().filter(e -> MessageUtils.isAssignableFrom((String)e.getKey(), protocolName)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap implicitMatchs = new HashMap();
            for (Map.Entry<String, List<ImplicitMethod>> implicitEntry : implicitMethodCache.entrySet()) {
                String implicitEntryKey = implicitEntry.getKey();
                List<ImplicitMethod> implicitEntryValue = implicitEntry.getValue();
                Map<String, List> implicitServiceMethods = serviceMethodCache.entrySet().stream().filter(e -> MessageUtils.isAssignableFrom((String)e.getKey(), implicitEntryKey)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (MessageUtils.isAssignableFrom(implicitEntryKey, protocolName) || implicitServiceMethods.isEmpty()) continue;
                for (Map.Entry<String, List> implicitServiceMethodEntry : implicitServiceMethods.entrySet()) {
                    String implicitServiceMethodEntryKey = implicitServiceMethodEntry.getKey();
                    List implicitServiceMethodEntryValue = implicitServiceMethodEntry.getValue();
                    List filteredServiceMethods = implicitServiceMethodEntryValue.stream().filter(ServiceMethod::isAllowImplicit).collect(Collectors.toList());
                    List filteredImplicitMethods = implicitEntryValue.stream().filter(v -> MessageUtils.isAssignableFrom(v.getInput(), protocolName)).collect(Collectors.toList());
                    if (filteredServiceMethods.isEmpty() || filteredImplicitMethods.isEmpty()) continue;
                    for (ServiceMethod filteredServiceMethod : filteredServiceMethods) {
                        Object service = filteredServiceMethod.getService();
                        Optional<ImplicitMethod> first = filteredImplicitMethods.stream().filter(m -> m.getImplicitObject() == service).findFirst();
                        if (first.isPresent()) {
                            filteredServiceMethod.setImplicitMethod(first.get());
                            continue;
                        }
                        filteredServiceMethod.setImplicitMethod((ImplicitMethod)filteredImplicitMethods.get(0));
                    }
                    implicitMatchs.put(implicitServiceMethodEntryKey, filteredServiceMethods);
                }
            }
            serviceMatchs.putAll(implicitMatchs);
            serviceMatchs = serviceMatchs.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(ServiceMethod::getChainName));
            for (List value : serviceMatchs.values()) {
                Integer repeatOrder = MessageUtils.repeatOrder(value);
                if (repeatOrder == null || MessageUtils.orderIsLast(repeatOrder, value)) continue;
                throw new MessageWarnException(MessageErrorConstants.MESSAGE_ERROR(), String.format("repeat order : %s for request %s", repeatOrder, protocolName));
            }
            this.protocolServiceMethodCache.put(protocolName, serviceMatchs);
        }
        return this.serviceMethod2Wrapper(this.protocolServiceMethodCache.get(protocolName));
    }

    private Map<String, List<MethodExecuteWrapper>> serviceMethod2Wrapper(Map<String, List<ServiceMethod>> source) {
        HashMap<String, List<MethodExecuteWrapper>> target = new HashMap<String, List<MethodExecuteWrapper>>();
        source.forEach((k, v) -> target.put((String)k, v.stream().map(MethodExecuteWrapper::new).collect(Collectors.toList())));
        return target;
    }
}

