/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.parser;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.linkis.message.annotation.Chain;
import org.apache.linkis.message.annotation.NotImplicit;
import org.apache.linkis.message.annotation.Order;
import org.apache.linkis.message.annotation.Receiver;
import org.apache.linkis.message.builder.ServiceMethodContext;
import org.apache.linkis.message.parser.ServiceMethod;
import org.apache.linkis.message.parser.ServiceParser;
import org.springframework.aop.support.AopUtils;

public class DefaultServiceParser
implements ServiceParser {
    @Override
    public Map<String, List<ServiceMethod>> parse(Object service) {
        Method[] methods = AopUtils.getTargetClass((Object)service).getMethods();
        return Arrays.stream(methods).filter(this::methodFilterPredicate).map(m -> this.getServiceMethod((Method)m, service)).collect(Collectors.groupingBy(ServiceMethod::getProtocolName));
    }

    private ServiceMethod getServiceMethod(Method method, Object service) {
        Parameter parameter;
        NotImplicit annotation;
        Parameter[] parameters;
        Chain chain;
        ServiceMethod serviceMethod = new ServiceMethod();
        serviceMethod.setMethod(method);
        serviceMethod.setService(service);
        serviceMethod.setAlias(String.format("%s.%s", service.getClass().getName(), method.getName()));
        Order order = method.getAnnotation(Order.class);
        if (order != null) {
            serviceMethod.setOrder(order.value());
        }
        if ((chain = method.getAnnotation(Chain.class)) != null) {
            serviceMethod.setChainName(chain.value());
        }
        if ((parameters = method.getParameters()).length == 2) {
            serviceMethod.setHasMethodContext(true);
            if (ServiceMethodContext.class.isAssignableFrom(parameters[0].getType())) {
                serviceMethod.setMethodContextOnLeft(true);
            }
        }
        if ((annotation = (parameter = Arrays.stream(parameters).filter(p -> !ServiceMethodContext.class.isAssignableFrom(p.getType())).findFirst().get()).getAnnotation(NotImplicit.class)) != null) {
            serviceMethod.setAllowImplicit(false);
        }
        serviceMethod.setProtocolName(parameter.getType().getName());
        return serviceMethod;
    }

    private boolean methodFilterPredicate(Method method) {
        if (method.getAnnotation(Receiver.class) != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (method.getParameterCount() == 1) {
                return !ServiceMethodContext.class.isAssignableFrom(parameterTypes[0]);
            }
            if (method.getParameterCount() == 2) {
                boolean hasContext = Arrays.stream(parameterTypes).anyMatch(ServiceMethodContext.class::isAssignableFrom);
                boolean allContext = Arrays.stream(parameterTypes).allMatch(ServiceMethodContext.class::isAssignableFrom);
                return hasContext && !allContext;
            }
        }
        return false;
    }
}

