/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.parser;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.linkis.message.annotation.Implicit;
import org.apache.linkis.message.parser.ImplicitMethod;
import org.apache.linkis.message.parser.ImplicitParser;
import org.apache.linkis.protocol.message.RequestProtocol;

public class DefaultImplicitParser
implements ImplicitParser {
    @Override
    public Map<String, List<ImplicitMethod>> parse(Object implicitObject) {
        Method[] methods = implicitObject.getClass().getMethods();
        return Arrays.stream(methods).filter(this::methodFilterPredicate).map(m -> this.getImplicitMethod((Method)m, implicitObject)).collect(Collectors.groupingBy(ImplicitMethod::getOutput));
    }

    private ImplicitMethod getImplicitMethod(Method method, Object implicitObject) {
        ImplicitMethod implicitMethod = new ImplicitMethod();
        implicitMethod.setMethod(method);
        implicitMethod.setImplicitObject(implicitObject);
        implicitMethod.setInput(method.getParameterTypes()[0].getName());
        implicitMethod.setOutput(method.getReturnType().getName());
        return implicitMethod;
    }

    private boolean methodFilterPredicate(Method method) {
        if (method.getAnnotation(Implicit.class) != null && method.getParameterCount() == 1 && !Void.TYPE.equals(method.getReturnType())) {
            Class<?> input = method.getParameterTypes()[0];
            return RequestProtocol.class.isAssignableFrom(input) && !method.getReturnType().isAssignableFrom(input);
        }
        return false;
    }
}

