/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.builder;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.message.builder.MessageJob;
import org.apache.linkis.message.builder.MessageJobTimeoutPolicy;
import org.apache.linkis.message.builder.ServiceMethodContext;
import org.apache.linkis.message.context.MessageSchedulerContext;
import org.apache.linkis.message.exception.MessageWarnException;
import org.apache.linkis.protocol.message.RequestProtocol;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.SchedulerEventState;
import scala.concurrent.duration.Duration;

public class DefaultServiceMethodContext
implements ServiceMethodContext {
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final ThreadLocal<Set<Integer>> skips = new ThreadLocal();
    private final ThreadLocal<Job> job = new ThreadLocal();

    @Override
    public void putAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public void putIfAbsent(String key, Object value) {
        if (!this.notNull(key)) {
            this.putAttribute(key, value);
        }
    }

    @Override
    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public <T> T getAttributeOrDefault(String key, T defaultValue) {
        return (T)this.attributes.getOrDefault(key, defaultValue);
    }

    @Override
    public String getUser() {
        return (String)this.getAttribute("_username_");
    }

    @Override
    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getAttribute("_req_");
    }

    @Override
    public boolean notNull(String key) {
        return this.attributes.get(key) != null;
    }

    @Override
    public MessageJob publish(RequestProtocol requestProtocol) throws MessageWarnException {
        MessageSchedulerContext context = (MessageSchedulerContext)this.getAttribute("_context_");
        return context.getPublisher().publish(requestProtocol, this);
    }

    @Override
    public void send(Object message) {
        Sender sender = (Sender)this.getAttribute("_sender_");
        sender.send(message);
    }

    @Override
    public Object ask(Object message) {
        Sender sender = (Sender)this.getAttribute("_sender_");
        return sender.ask(message);
    }

    @Override
    public Object ask(Object message, Duration timeout) {
        Sender sender = (Sender)this.getAttribute("_sender_");
        return sender.ask(message, timeout);
    }

    @Override
    public Sender getSender() {
        return (Sender)this.getAttribute("_sender_");
    }

    @Override
    public void setTimeoutPolicy(MessageJobTimeoutPolicy policy) {
        this.putAttribute("_timeout_policy_", (Object)policy);
    }

    @Override
    public void setResult(Object result) {
        this.putAttribute("_result_", result);
    }

    @Override
    public <T> T getResult() {
        return this.getAttribute("_result_");
    }

    @Override
    public boolean isInterrupted() {
        return SchedulerEventState.Cancelled() == this.job.get().getState();
    }

    @Override
    public boolean isCancel() {
        return SchedulerEventState.Cancelled() == this.job.get().getState();
    }

    @Override
    public boolean isSuccess() {
        return SchedulerEventState.Succeed() == this.job.get().getState();
    }

    public void setJob(Job job) {
        this.job.set(job);
    }

    public void removeJob() {
        this.job.remove();
    }

    public void setSkips(Integer ... orders) {
        Set<Integer> oldOrders = this.skips.get();
        if (oldOrders == null) {
            HashSet<Integer> newOrders = new HashSet<Integer>(Arrays.asList(orders));
            this.skips.set(newOrders);
        } else {
            oldOrders.addAll(Arrays.asList(orders));
        }
    }

    public void removeSkips() {
        this.skips.remove();
    }
}

