/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.message.builder;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.apache.linkis.message.builder.MessageJob;
import org.apache.linkis.message.builder.ServiceMethodContext;
import org.apache.linkis.message.context.AbstractMessageSchedulerContext;
import org.apache.linkis.message.scheduler.MethodExecuteWrapper;
import org.apache.linkis.protocol.message.RequestProtocol;
import org.apache.linkis.scheduler.executer.ExecuteRequest;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.JobInfo;
import org.apache.linkis.scheduler.queue.SchedulerEventState;
import scala.Enumeration;

public class DefaultMessageJob
extends Job
implements MessageJob {
    private RequestProtocol requestProtocol;
    private Map<String, List<MethodExecuteWrapper>> methodExecuteWrappers;
    private ServiceMethodContext smc;
    private AbstractMessageSchedulerContext context;
    Thread blockThread = null;

    @Override
    public RequestProtocol getRequestProtocol() {
        return this.requestProtocol;
    }

    @Override
    public void setRequestProtocol(RequestProtocol requestProtocol) {
        this.requestProtocol = requestProtocol;
    }

    @Override
    public Map<String, List<MethodExecuteWrapper>> getMethodExecuteWrappers() {
        return this.methodExecuteWrappers;
    }

    @Override
    public void setMethodExecuteWrappers(Map<String, List<MethodExecuteWrapper>> methodExecuteWrappers) {
        this.methodExecuteWrappers = methodExecuteWrappers;
    }

    @Override
    public ServiceMethodContext getMethodContext() {
        return this.smc;
    }

    @Override
    public void setMethodContext(ServiceMethodContext smc) {
        this.smc = smc;
    }

    @Override
    public AbstractMessageSchedulerContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(AbstractMessageSchedulerContext context) {
        this.context = context;
    }

    public void init() {
    }

    public ExecuteRequest jobToExecuteRequest() {
        return () -> null;
    }

    public String getName() {
        return this.getId();
    }

    public JobInfo getJobInfo() {
        return null;
    }

    public void close() throws IOException {
    }

    public Thread getBlockThread() {
        return this.blockThread;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            this.cancel();
        }
        return true;
    }

    @Override
    public Object get() throws ExecutionException, InterruptedException {
        if (!this.isCompleted()) {
            this.waitComplete(false, -1L);
        }
        return this.handleResult();
    }

    @Override
    public Object getPartial() {
        return this.getMethodContext().getResult();
    }

    public Object handleResult() throws ExecutionException {
        if (this.isSucceed()) {
            return this.getMethodContext().getResult();
        }
        throw new ExecutionException(this.getErrorResponse().t());
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (unit == null) {
            unit = TimeUnit.NANOSECONDS;
        }
        if (!this.isCompleted() && !SchedulerEventState.isCompleted((Enumeration.Value)SchedulerEventState.apply((int)this.waitComplete(true, unit.toNanos(timeout))))) {
            String msg = "task: " + this.requestProtocol + "time out " + timeout;
            throw new TimeoutException(msg);
        }
        return this.handleResult();
    }

    private int waitComplete(boolean timed, long nanos) throws InterruptedException {
        long endTime;
        long l = endTime = timed ? System.nanoTime() + nanos : -1L;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.isCompleted()) {
                return this.getState().id();
            }
            if (this.blockThread == null) {
                this.blockThread = Thread.currentThread();
                continue;
            }
            if (timed) {
                nanos = endTime - System.nanoTime();
                if (nanos <= 0L) {
                    return this.getState().id();
                }
                LockSupport.parkNanos(this, nanos);
                continue;
            }
            LockSupport.park(this);
        }
    }
}

