/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.karaf.features.internal.model.processing.FeaturesProcessing;
import org.apache.karaf.features.internal.model.processing.ObjectFactory;
import org.apache.karaf.util.xml.IndentingXMLEventWriter;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.util.collections.PropertyResolver;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class FeaturesProcessingSerializer {
    public static Logger LOG = LoggerFactory.getLogger(FeaturesProcessingSerializer.class);
    private final BundleContext bundleContext;
    private JAXBContext FEATURES_PROCESSING_CONTEXT;

    public FeaturesProcessingSerializer() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        this.bundleContext = bundle == null ? null : bundle.getBundleContext();
        try {
            this.FEATURES_PROCESSING_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FeaturesProcessing read(InputStream stream) throws Exception {
        return this.read(stream, null);
    }

    public FeaturesProcessing read(InputStream stream, Properties versions) throws Exception {
        Unmarshaller unmarshaller = this.FEATURES_PROCESSING_CONTEXT.createUnmarshaller();
        UnmarshallerHandler handler = unmarshaller.getUnmarshallerHandler();
        final DictionaryPropertyResolver resolver = this.bundleContext == null ? new DictionaryPropertyResolver(versions) : new DictionaryPropertyResolver(versions, new BundleContextPropertyResolver(this.bundleContext));
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        XMLReader xmlReader = spf.newSAXParser().getXMLReader();
        xmlReader.setContentHandler(new ResolvingContentHandler(new Properties(){

            @Override
            public String getProperty(String key) {
                return resolver.get(key);
            }

            @Override
            public String getProperty(String key, String defaultValue) {
                String value = resolver.get(key);
                return value == null ? defaultValue : value;
            }
        }, (ContentHandler)handler));
        xmlReader.parse(new InputSource(stream));
        return (FeaturesProcessing)handler.getResult();
    }

    public void write(FeaturesProcessing model, OutputStream output) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Marshaller marshaller = this.FEATURES_PROCESSING_CONTEXT.createMarshaller();
            marshaller.marshal((Object)model, (Result)new StreamResult(baos));
            HashMap<String, Boolean> emptyElements = new HashMap<String, Boolean>();
            emptyElements.put("blacklistedRepositories", model.getBlacklistedRepositories().size() == 0);
            emptyElements.put("blacklistedFeatures", model.getBlacklistedFeatures().size() == 0);
            emptyElements.put("blacklistedBundles", model.getBlacklistedBundles().size() == 0);
            emptyElements.put("overrideBundleDependency", model.getOverrideBundleDependency().getRepositories().size() + model.getOverrideBundleDependency().getFeatures().size() + model.getOverrideBundleDependency().getBundles().size() == 0);
            emptyElements.put("bundleReplacements", model.getBundleReplacements().getOverrideBundles().size() == 0);
            emptyElements.put("featureReplacements", model.getFeatureReplacements().getReplacements().size() == 0);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\n");
            writer.write("    Configuration generated by Karaf Assembly Builder\n");
            writer.write("-->\n");
            writer.flush();
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("feature-processing-comments.properties"));
            XMLEventReader xmlEventReader = XMLInputFactory.newFactory().createXMLEventReader(new ByteArrayInputStream(baos.toByteArray()));
            IndentingXMLEventWriter xmlEventWriter = new IndentingXMLEventWriter(XMLOutputFactory.newFactory().createXMLEventWriter(writer), "    ");
            XMLEventFactory evFactory = XMLEventFactory.newFactory();
            int depth = 0;
            boolean skipClose = false;
            while (xmlEventReader.hasNext()) {
                String tag;
                XMLEvent ev = xmlEventReader.nextEvent();
                int type = ev.getEventType();
                if (type == 7 || type == 8) continue;
                if (type == 1) {
                    skipClose = false;
                    if (++depth == 2) {
                        tag = ev.asStartElement().getName().getLocalPart();
                        String comment = props.getProperty(tag);
                        xmlEventWriter.add(evFactory.createCharacters("\n    "));
                        xmlEventWriter.add(evFactory.createComment(" " + comment + " "));
                    }
                } else if (type == 2) {
                    skipClose = false;
                    if (--depth == 1) {
                        tag = ev.asEndElement().getName().getLocalPart();
                        String string = props.getProperty(tag);
                    }
                }
                if (type == 2 && depth == 0) {
                    xmlEventWriter.add(evFactory.createCharacters("\n"));
                }
                if (!skipClose) {
                    xmlEventWriter.add(ev);
                }
                if (type != 1 || depth != 1) continue;
                xmlEventWriter.add(evFactory.createCharacters("\n"));
            }
            xmlEventWriter.add(evFactory.createEndDocument());
            writer.flush();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    private static class ResolvingContentHandler
    implements ContentHandler {
        public static Logger LOG = LoggerFactory.getLogger(ResolvingContentHandler.class);
        private Properties properties;
        private ContentHandler target;
        private boolean inElement = false;
        private StringWriter sw = new StringWriter();

        public ResolvingContentHandler(Properties properties, ContentHandler target) {
            this.properties = properties;
            this.target = target;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.target.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.target.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.target.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.target.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.target.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            AttributesImpl resolvedAttributes = new AttributesImpl(atts);
            for (int i = 0; i < atts.getLength(); ++i) {
                resolvedAttributes.setAttribute(i, atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), this.resolve(atts.getValue(i)));
            }
            if (this.inElement) {
                this.flushBuffer(false);
            }
            this.inElement = true;
            this.target.startElement(uri, localName, qName, resolvedAttributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inElement) {
                this.flushBuffer(true);
                this.inElement = false;
            }
            this.target.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inElement) {
                this.sw.append(new String(ch, start, length));
            } else {
                this.target.characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.target.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.target.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.target.skippedEntity(name);
        }

        private void flushBuffer(boolean resolve) throws SAXException {
            String value = this.sw.toString();
            String resolved = resolve ? this.resolve(value) : value;
            this.target.characters(resolved.toCharArray(), 0, resolved.length());
            this.sw = new StringWriter();
        }

        private String resolve(String value) {
            String resolved = PropertyResolver.resolve(this.properties, value);
            if (resolved.contains("${")) {
                LOG.warn("Value {} has unresolved properties, please check configuration.", (Object)value);
            }
            return resolved;
        }
    }
}

