/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogAppendInfo;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001\u0002\u0012$\u0001!B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\nw\u0001\u0011\t\u0011)A\u0005y\tC\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\"B,\u0001\t\u0003A\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B2\t\u000f!\u0004!\u0019!C\u0005S\"1!\u000f\u0001Q\u0001\n)Dqa\u001d\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004u\u0001\u0001\u0006IA\u001b\u0005\bk\u0002\u0001\r\u0011\"\u0003w\u0011%\tY\u0001\u0001a\u0001\n\u0013\ti\u0001C\u0004\u0002\u001a\u0001\u0001\u000b\u0015B<\t\u000f\u0005m\u0001\u0001\"\u0015\u0002\u001e!9\u0011Q\u0005\u0001\u0005R\u0005\u001d\u0002bBA\u0019\u0001\u0011E\u00131\u0007\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tI\b\u0001C!\u0003wBq!a1\u0001\t#\n)\rC\u0004\u0002N\u0002!\t&a4\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u00111\u001d\u0001\u0005B\u0005\u0015\bbBA\u0000\u0001\u0011E#\u0011\u0001\u0005\b\u0005\u0013\u0001A\u0011\tB\u0006\u0011\u001d\u0011I\u0002\u0001C)\u00057AqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u00038\u0001!IA!\u000f\t\u000f\tu\u0002\u0001\"\u0003\u0003@!9!\u0011\r\u0001\u0005\u0002\t\r$!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012T!\u0001J\u0013\u0002\rM,'O^3s\u0015\u00051\u0013!B6bM.\f7\u0001A\n\u0003\u0001%\u0002\"AK\u0016\u000e\u0003\rJ!\u0001L\u0012\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u0006!a.Y7f!\ty\u0003H\u0004\u00021mA\u0011\u0011\u0007N\u0007\u0002e)\u00111gJ\u0001\u0007yI|w\u000e\u001e \u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003oQ\nAb]8ve\u000e,'I]8lKJ\u0004\"!\u0010!\u000e\u0003yR!aP\u0013\u0002\u000f\rdWo\u001d;fe&\u0011\u0011I\u0010\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0013\tY4&\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002+\u000b&\u0011ai\t\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\tgC&dW\r\u001a)beRLG/[8ogB\u0011!&S\u0005\u0003\u0015\u000e\u0012\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002\u0015I,\u0007\u000f\\5dC6;'\u000f\u0005\u0002+\u001b&\u0011aj\t\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\tQ\u0013+\u0003\u0002SG\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM]\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u0004\"AK+\n\u0005Y\u001b#\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003\u0019a\u0014N\\5u}QA\u0011LW.];z{\u0006\r\u0005\u0002+\u0001!)Q\u0006\u0003a\u0001]!)1\b\u0003a\u0001y!)1\t\u0003a\u0001\t\")q\t\u0003a\u0001\u0011\")1\n\u0003a\u0001\u0019\")q\n\u0003a\u0001!\")1\u000b\u0003a\u0001)\u0006I!/\u001a9mS\u000e\f\u0017\nZ\u000b\u0002GB\u0011A-Z\u0007\u0002i%\u0011a\r\u000e\u0002\u0004\u0013:$\u0018A\u0003:fa2L7-Y%eA\u0005AQ.\u0019=CsR,7/F\u0001k!\tY\u0007/D\u0001m\u0015\tig.\u0001\u0003mC:<'\"A8\u0002\t)\fg/Y\u0005\u0003c2\u0014q!\u00138uK\u001e,'/A\u0005nCb\u0014\u0015\u0010^3tA\u0005Ia-\u001a;dQNK'0Z\u0001\u000bM\u0016$8\r[*ju\u0016\u0004\u0013aE5o!J|wM]3tgB\u000b'\u000f^5uS>tW#A<\u0011\u0007\u0011D(0\u0003\u0002zi\t1q\n\u001d;j_:\u00042a_A\u0004\u001b\u0005a(BA?\u007f\u0003\u0019\u0019w.\\7p]*\u0011ae \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000b\t1a\u001c:h\u0013\r\tI\u0001 \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003]Ig\u000e\u0015:pOJ,7o\u001d)beRLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\u0005U\u0001c\u00013\u0002\u0012%\u0019\u00111\u0003\u001b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003/\u0001\u0012\u0011!a\u0001o\u0006\u0019\u0001\u0010J\u0019\u0002)%t\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8!\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\t\u0005}\u0011\u0011\u0005\t\u0004Ib\u001c\u0007BBA\u0012%\u0001\u0007!0\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\t\u0005%\u0012q\u0006\t\u0004I\u0006-\u0012bAA\u0017i\t!Aj\u001c8h\u0011\u0019\t\u0019c\u0005a\u0001u\u0006\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\u0005U\u0012QHA !\u0011!\u00070a\u000e\u0011\u0007)\nI$C\u0002\u0002<\r\u0012ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000e\u0003\u0004\u0002$Q\u0001\rA\u001f\u0005\u0007\u0003\u0003\"\u0002\u0019A2\u0002\u000b\u0015\u0004xn\u00195\u0002\u001f\u0019,Go\u00195Ge>lG*Z1eKJ$B!a\u0012\u0002bA1\u0011\u0011JA(\u0003'j!!a\u0013\u000b\u0007\u00055C'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0015\u0002L\t\u00191+Z9\u0011\r\u0011\f)F_A-\u0013\r\t9\u0006\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005m\u0013QL\u0007\u0002\u0001%\u0019\u0011qL\u0016\u0003\u0013\u0019+Go\u00195ECR\f\u0007bBA2+\u0001\u0007\u0011QM\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0003O\n\u0019H\u0004\u0003\u0002j\u0005=TBAA6\u0015\r\ti\u0007`\u0001\te\u0016\fX/Z:ug&!\u0011\u0011OA6\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\t)(a\u001e\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011\u0011OA6\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA\u0011QPAF\u0003\u001b\u000b\t\n\u0005\u0003eq\u0006}\u0004\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015U%A\u0002m_\u001eLA!!#\u0002\u0004\niAj\\4BaB,g\u000eZ%oM>Da!a\t\u0017\u0001\u0004Q\bbBAH-\u0001\u0007\u0011\u0011F\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u0002\u0014Z\u0001\r!!&\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0019\t9*!-\u00028:!\u0011\u0011TAW\u001d\u0011\tY*a+\u000f\t\u0005u\u0015\u0011\u0016\b\u0005\u0003?\u000b9K\u0004\u0003\u0002\"\u0006\u0015fbA\u0019\u0002$&\u0011\u0011QA\u0005\u0005\u0003\u0003\t\u0019!\u0003\u0002'\u007f&\u0011QP`\u0005\u0004\u0003[b\u0018\u0002BAX\u0003W\nQBR3uG\"\u0014Vm\u001d9p]N,\u0017\u0002BAZ\u0003k\u0013Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002BAX\u0003W\u0002B!!/\u0002@6\u0011\u00111\u0018\u0006\u0004\u0003{c\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0002B\u0006m&a\u0002*fG>\u0014Hm]\u0001\u001eM\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR1\u0011\u0011FAd\u0003\u0013Da!a\t\u0018\u0001\u0004Q\bBBAf/\u0001\u00071-A\u0006mK\u0006$WM]#q_\u000eD\u0017a\u00074fi\u000eDG*\u0019;fgR|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0004\u0002*\u0005E\u00171\u001b\u0005\u0007\u0003GA\u0002\u0019\u0001>\t\r\u0005-\u0007\u00041\u0001d\u0003\u0001zgMZ:fiNs\u0017\r]:i_R4%o\\7DkJ\u0014XM\u001c;SKBd\u0017nY1\u0015\r\u0005e\u0017q\\Aq!\u0011\t\t)a7\n\t\u0005u\u00171\u0011\u0002\u0012\u0019><wJ\u001a4tKR\u001cf.\u00199tQ>$\bBBA\u00123\u0001\u0007!\u0010\u0003\u0004\u0002Lf\u0001\raY\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\u0005\u001d\u00181\u001f\t\b\u0003\u0013\nIO_Aw\u0013\u0011\tY/a\u0013\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002j\u0005=\u0018\u0002BAy\u0003W\u0012a\"\u00129pG\",e\u000eZ(gMN,G\u000fC\u0004\u0002vj\u0001\r!a>\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0004\u0002J\u0005%(0!?\u0011\t\u0005m\u00131`\u0005\u0004\u0003{\\#!C#q_\u000eDG)\u0019;b\u0003}I7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\rZ\u000b\u0003\u0005\u0007\u00012\u0001\u001aB\u0003\u0013\r\u00119\u0001\u000e\u0002\b\u0005>|G.Z1o\u0003!!(/\u001e8dCR,GCBA\b\u0005\u001b\u0011y\u0001\u0003\u0004\u0002$q\u0001\rA\u001f\u0005\b\u0005#a\u0002\u0019\u0001B\n\u0003=!(/\u001e8dCRLwN\\*uCR,\u0007c\u0001\u0016\u0003\u0016%\u0019!qC\u0012\u0003+=3gm]3u)J,hnY1uS>t7\u000b^1uK\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0007\u0003\u001f\u0011iBa\b\t\r\u0005\rR\u00041\u0001{\u0011\u001d\u0011\t#\ba\u0001\u0003S\taa\u001c4gg\u0016$\u0018A\u00058fqR\u0014V-\u00193z!\u0006\u0014H/\u001b;j_:$BAa\n\u00032A!A\r\u001fB\u0015!\u0019!\u0017Q\u000b>\u0003,A\u0019!F!\f\n\u0007\t=2EA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X\rC\u0004\u00034y\u0001\rA!\u000e\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0011\u000f\u0005%\u0013\u0011\u001e>\u0003,\u000512/\u001a7fGR\u0004\u0016M\u001d;ji&|g\u000eV8GKR\u001c\u0007\u000e\u0006\u0003\u0003(\tm\u0002b\u0002B\u001a?\u0001\u0007!QG\u0001\u0017EVLG\u000e\u001a$fi\u000eDgi\u001c:QCJ$\u0018\u000e^5p]R1!\u0011\tB-\u0005;\u0002bAa\u0011\u0003R\t]c\u0002\u0002B#\u0005\u001brAAa\u0012\u0003L9\u0019\u0011G!\u0013\n\u0003\u0019J!\u0001J\u0013\n\u0007\t=3%A\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\n\t\tM#Q\u000b\u0002\u0015%\u0016\u001cX\u000f\u001c;XSRD\u0007+\u0019:uSRLwN\\:\u000b\u0007\t=3\u0005\u0005\u0003eq\u0006\u0015\u0004B\u0002B.A\u0001\u0007!0\u0001\u0002ua\"9!q\f\u0011A\u0002\t-\u0012A\u00034fi\u000eD7\u000b^1uK\u0006Q!-^5mI\u001a+Go\u00195\u0015\t\t\u0005#Q\r\u0005\b\u0005g\t\u0003\u0019\u0001B\u001b\u0001")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), request.version() <= 2, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel());
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray())).mkString(",")).toString());
        }
        return (Seq)partitionData.elem;
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Replica futureReplica = this.replicaMgr.futureLocalReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        if (fetchOffset != futureReplica.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureReplica.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, true);
        long futureReplicaHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(futureReplica.logEndOffset()), partitionData.highWatermark);
        futureReplica.highWatermark_$eq(new LogOffsetMetadata(futureReplicaHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        futureReplica.maybeIncrementLogStartOffset(partitionData.logStartOffset);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        LogOffsetSnapshot offsetSnapshot = this.offsetSnapshotFromCurrentReplica(topicPartition, leaderEpoch);
        return offsetSnapshot.logStartOffset();
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        LogOffsetSnapshot offsetSnapshot = this.offsetSnapshotFromCurrentReplica(topicPartition, leaderEpoch);
        return offsetSnapshot.logEndOffset().messageOffset();
    }

    private LogOffsetSnapshot offsetSnapshotFromCurrentReplica(TopicPartition topicPartition, int leaderEpoch) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        return partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                TopicPartition tp = (TopicPartition)tuple22._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple22._2();
                try {
                    EpochEndOffset epochEndOffset;
                    if (epochData.leaderEpoch == -1) {
                        epochEndOffset = new EpochEndOffset(-1, -1L);
                    } else {
                        Partition partition = $this.replicaMgr.getPartitionOrException(tp, false);
                        epochEndOffset = partition.lastOffsetForLeaderEpoch(epochData.currentLeaderEpoch, epochData.leaderEpoch, false);
                    }
                    EpochEndOffset endOffset = epochEndOffset;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)t), -1, -1L));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return true;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateFullyAndStartAt(offset, true);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((TraversableOnce)partitionMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            Tuple2 tuple2;
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$less((Object)((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                tuple2 = left;
                return tuple2;
            }
            tuple2 = right;
            return tuple2;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Option option;
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable & scala.Serializable)tp -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            option = var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        SetLike setLike;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaMgr.futureLocalReplicaOrException(tp).logStartOffset();
            setLike = requestMap.put(tp, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch()))));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            setLike = partitionsWithError.$plus$eq((Object)tp);
        }
        None$ fetchRequestOpt = requestMap.isEmpty() ? None$.MODULE$ : new Some((Object)FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())));
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        if (this.quota.isQuotaExceeded()) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        } else {
            AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions2;
            Some some;
            Tuple2 tuple2;
            Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitionMap);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                resultWithPartitions2 = this.buildFetchForPartition(tp, fetchState);
            } else if (None$.MODULE$.equals(option)) {
                resultWithPartitions2 = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
            } else {
                throw new MatchError(option);
            }
            resultWithPartitions = resultWithPartitions2;
        }
        return resultWithPartitions;
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            FetchPartitionData data = (FetchPartitionData)tuple2._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable & scala.Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, (BaseRecords)data.records()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
        boolean bl = partitionFetchState.isReadyForFetch();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        Option fetchStateOpt = partitionMap$1.get((Object)tp);
        fetchStateOpt.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isReadyForFetch())).foreach((Function1 & Serializable & scala.Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(ReplicaAlterLogDirsThread $this, Map partitionMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
        $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(133).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
    }
}

