/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.utils.Time;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001\u001d\u0011!DU3qY&\u001c\u0017MR3uG\",'O\u00117pG.LgnZ*f]\u0012T!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\ta!\t\\8dW&twmU3oI\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u000591\r\\;ti\u0016\u0014\u0018BA\r\u0017\u00059\u0011%o\\6fe\u0016sG\rU8j]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\u001fuI!A\b\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u0012,\u001b\u0005\u0019#B\u0001\u0011%\u0015\t)c%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u001dR!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO&\u0011Af\t\u0002\b\u001b\u0016$(/[2t\u0011!q\u0003A!A!\u0002\u0013y\u0013\u0001\u0002;j[\u0016\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\n$\u0001\u0002+j[\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"!\u0003\u001d\n\u0005eR!aA%oi\"A1\b\u0001B\u0001B\u0003%A(\u0001\u0005dY&,g\u000e^%e!\ti\u0004I\u0004\u0002\n}%\u0011qHC\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@\u0015!)A\t\u0001C\u0001\u000b\u00061A(\u001b8jiz\"rAR$I\u0013*[E\n\u0005\u0002\u0010\u0001!)1c\u0011a\u0001)!)1d\u0011a\u00019!)\u0001e\u0011a\u0001C!)af\u0011a\u0001_!)ag\u0011a\u0001o!)1h\u0011a\u0001y!9a\n\u0001b\u0001\n\u0013y\u0015AC:pkJ\u001cWMT8eKV\t\u0001\u000b\u0005\u0002R%6\tA%\u0003\u0002TI\t!aj\u001c3f\u0011\u0019)\u0006\u0001)A\u0005!\u0006Y1o\\;sG\u0016tu\u000eZ3!\u0011\u001d9\u0006A1A\u0005\na\u000bQb]8dW\u0016$H+[7f_V$X#A\u001c\t\ri\u0003\u0001\u0015!\u00038\u00039\u0019xnY6fiRKW.Z8vi\u0002Bq\u0001\u0018\u0001C\u0002\u0013%Q,A\u0007oKR<xN]6DY&,g\u000e^\u000b\u0002=B\u0011qLY\u0007\u0002A*\u0011\u0011MJ\u0001\bG2LWM\u001c;t\u0013\t\u0019\u0007MA\u0007OKR<xN]6DY&,g\u000e\u001e\u0005\u0007K\u0002\u0001\u000b\u0011\u00020\u0002\u001d9,Go^8sW\u000ec\u0017.\u001a8uA!)q\r\u0001C!Q\u0006Y1/\u001a8e%\u0016\fX/Z:u)\tIG\u000e\u0005\u0002`U&\u00111\u000e\u0019\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0011\u0015ig\r1\u0001o\u00039\u0011X-];fgR\u0014U/\u001b7eKJ\u00044a\\A\b!\u0015\u0001\u0018QAA\u0006\u001d\t\txP\u0004\u0002s{:\u00111\u000f \b\u0003int!!\u001e>\u000f\u0005YLX\"A<\u000b\u0005a4\u0011A\u0002\u001fs_>$h(C\u0001+\u0013\tA\u0013&\u0003\u0002\u0006O%\u0011QEJ\u0005\u0003}\u0012\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u0003\t\u0019!A\bBEN$(/Y2u%\u0016\fX/Z:u\u0015\tqH%\u0003\u0003\u0002\b\u0005%!a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u0003\t\u0019\u0001\u0005\u0003\u0002\u000e\u0005=A\u0002\u0001\u0003\f\u0003#a\u0017\u0011!A\u0001\u0006\u0003\t\u0019BA\u0002`II\nB!!\u0006\u0002\u001cA\u0019\u0011\"a\u0006\n\u0007\u0005e!BA\u0004O_RD\u0017N\\4\u0011\t\u0005u\u0011qD\u0007\u0003\u0003\u0007IA!!\t\u0002\u0004\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0004\u0002&\u0001!\t!a\n\u0002\u000b\rdwn]3\u0015\u0005\u0005%\u0002cA\u0005\u0002,%\u0019\u0011Q\u0006\u0006\u0003\tUs\u0017\u000e\u001e")
public class ReplicaFetcherBlockingSend
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final Time time;
    private final Node sourceNode;
    private final int socketTimeout;
    private final NetworkClient networkClient;

    private Node sourceNode() {
        return this.sourceNode;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        try {
            if (NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout())) {
                ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString(), requestBuilder, this.time.milliseconds(), true);
                return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
            }
            throw new SocketTimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to connect within ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.socketTimeout())})));
        }
        catch (Throwable throwable) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString());
            throw throwable;
        }
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public ReplicaFetcherBlockingSend(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId) {
        this.sourceBroker = sourceBroker;
        this.time = time;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)brokerConfig.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)brokerConfig, (ListenerName)brokerConfig.interBrokerListenerName(), (String)brokerConfig.saslMechanismInterBrokerProtocol(), (boolean)brokerConfig.saslInterBrokerHandshakeRequestEnable());
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)sourceBroker.id())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)fetcherId)).toString())}))).asJava(), false, channelBuilder);
        this.networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), time, false, new ApiVersions());
    }
}

