/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.OptionException;
import kafka.producer.ProducerConfig;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,\u0007K]8ek\u000e,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003%1\u0018\r\\5e\u0003J<7/F\u0001\u0017!\rIq#G\u0005\u00031)\u0011Q!\u0011:sCf\u0004\"AG\u000f\u000f\u0005%Y\u0012B\u0001\u000f\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011ad\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qQ\u0001BB\u0011\u0001A\u0003%a#\u0001\u0006wC2LG-\u0011:hg\u0002Bqa\t\u0001C\u0002\u0013\u0005Q#A\u0006j]Z\fG.\u001b3Be\u001e\u001c\bBB\u0013\u0001A\u0003%a#\u0001\u0007j]Z\fG.\u001b3Be\u001e\u001c\b\u0005C\u0003(\u0001\u0011\u0005\u0001&A\u000euKN$h+\u00197jI\u000e{gNZ5hg:+w\u000f\u0015:pIV\u001cWM\u001d\u000b\u0002SA\u0011\u0011BK\u0005\u0003W)\u0011A!\u00168ji\"\u0012a%\f\t\u0003]Mj\u0011a\f\u0006\u0003aE\nQA[;oSRT\u0011AM\u0001\u0004_J<\u0017B\u0001\u001b0\u0005\u0011!Vm\u001d;\t\u000bY\u0002A\u0011\u0001\u0015\u00027Q,7\u000f\u001e,bY&$7i\u001c8gS\u001e\u001cx\n\u001c3Qe>$WoY3sQ\u0011)\u0004hO\u001f\u0011\u0005%I\u0014B\u0001\u001e\u000b\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0002y\u0005IE\u000b[5tAQ,7\u000f\u001e\u0011iCN\u0004#-Z3oA\u0011,\u0007O]3dCR,G\rI1oI\u0002JG\u000fI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004\u0013\r\t4viV\u0014X\r\t:fY\u0016\f7/\u001a\u0018\"\u0003y\n\u0001\u0002\r\u00182a9\u0002d\u0006\r\u0015\u0003k5BQ!\u0011\u0001\u0005\u0002!\n!\u0003^3ti&sg/\u00197jI\u000e{gNZ5hg\"\u0012\u0001)\f\u0005\u0006\t\u0002!\t\u0001K\u0001\u0011i\u0016\u001cH\u000fU1sg\u0016\\U-\u001f)s_BD#aQ\u0017")
public class ConsoleProducerTest {
    private final String[] validArgs = (String[])((Object[])new String[]{"--broker-list", "localhost:1001,localhost:1002", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] invalidArgs = (String[])((Object[])new String[]{"--t", "t3"});

    public String[] validArgs() {
        return this.validArgs;
    }

    public String[] invalidArgs() {
        return this.invalidArgs;
    }

    @Test
    public void testValidConfigsNewProducer() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        KafkaProducer producer = new KafkaProducer(ConsoleProducer$.MODULE$.getNewProducerProps(config));
        producer.close();
    }

    @Test
    public void testValidConfigsOldProducer() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        new ProducerConfig(ConsoleProducer$.MODULE$.getOldProducerProps(config));
    }

    @Test
    public void testInvalidConfigs() {
        try {
            new ConsoleProducer.ProducerConfig(this.invalidArgs());
            Assert.fail((String)"Should have thrown an UnrecognizedOptionException");
        }
        catch (OptionException optionException) {
            // empty catch block
        }
    }

    @Test
    public void testParseKeyProp() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).newInstance();
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        String string = reader.keySeparator();
        String string2 = "#";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(reader.parseKey());
    }
}

