/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.NotRunning$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u000f\t\u00112+\u001a:wKJ\u001c\u0006.\u001e;e_^tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0005i\\\u0017BA\f\u0015\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0001\r\u0011\"\u0001 \u0003\u0019\u0019wN\u001c4jOV\t\u0001\u0005\u0005\u0002\u001dC%\u0011!E\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0004%\u0001\u0001\u0007I\u0011A\u0013\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0002'YA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t!QK\\5u\u0011\u001di3%!AA\u0002\u0001\n1\u0001\u001f\u00132\u0011\u0019y\u0003\u0001)Q\u0005A\u000591m\u001c8gS\u001e\u0004\u0003bB\u0019\u0001\u0005\u0004%\tAM\u0001\u0005Q>\u001cH/F\u00014!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003mC:<'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012aa\u0015;sS:<\u0007B\u0002\u001f\u0001A\u0003%1'A\u0003i_N$\b\u0005C\u0004?\u0001\t\u0007I\u0011\u0001\u001a\u0002\u000bQ|\u0007/[2\t\r\u0001\u0003\u0001\u0015!\u00034\u0003\u0019!x\u000e]5dA!9!\t\u0001b\u0001\n\u0003\u0019\u0015!B:f]R\fT#\u0001#\u0011\u0007\u0015S5'D\u0001G\u0015\t9\u0005*A\u0005j[6,H/\u00192mK*\u0011\u0011\nK\u0001\u000bG>dG.Z2uS>t\u0017BA&G\u0005\u0011a\u0015n\u001d;\t\r5\u0003\u0001\u0015!\u0003E\u0003\u0019\u0019XM\u001c;2A!9q\n\u0001b\u0001\n\u0003\u0019\u0015!B:f]R\u0014\u0004BB)\u0001A\u0003%A)\u0001\u0004tK:$(\u0007\t\u0005\u0006'\u0002!\t\u0005V\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002M!\u0012!K\u0016\t\u0003/fk\u0011\u0001\u0017\u0006\u0003\u00179I!A\u0017-\u0003\r\t+gm\u001c:f\u0011\u0015a\u0006\u0001\"\u0001U\u0003E!Xm\u001d;DY\u0016\fgn\u00155vi\u0012|wO\u001c\u0015\u00037z\u0003\"aV0\n\u0005\u0001D&\u0001\u0002+fgRDQA\u0019\u0001\u0005\u0002Q\u000bq\u0005^3ti\u000ecW-\u00198TQV$Hm\\<o/&$\b\u000eR3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fI\"\u0012\u0011M\u0018\u0005\u0006K\u0002!\t\u0001V\u0001$i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^t\u0017I\u001a;fe\u001a\u000b\u0017\u000e\\3e'R\f'\u000f^;qQ\t!g\f\u0003\u0004i\u0001\u0001&I![\u0001\u0017SNtuN\u001c#bK6|gnS1gW\u0006$\u0006N]3bIR\u0011!.\u001c\t\u0003O-L!\u0001\u001c\u0015\u0003\u000f\t{w\u000e\\3b]\")an\u001aa\u0001_\u0006\tA\u000f\u0005\u00025a&\u0011\u0011/\u000e\u0002\u0007)\"\u0014X-\u00193\t\u000bM\u0004A\u0011\u0001+\u00029Y,'/\u001b4z\u001d>tG)Y3n_:$\u0006N]3bIN\u001cF/\u0019;vg\")Q\u000f\u0001C\u0001)\u00069B/Z:u\u0007>t7/Z2vi&4Xm\u00155vi\u0012|wO\u001c\u0015\u0003iz\u0003")
public class ServerShutdownTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private KafkaConfig config;
    private final String host;
    private final String topic;
    private final List<String> sent1;
    private final List<String> sent2;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ServerShutdownTest serverShutdownTest = this;
        synchronized (serverShutdownTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @Test
    public void testCleanShutdown() {
        KafkaConfig x$17 = this.config();
        Option x$18 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$19 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$20 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        ObjectRef server = ObjectRef.create((Object)new KafkaServer(x$17, x$19, x$18, x$20));
        ((KafkaServer)server.elem).startup();
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1((KafkaServer)server.elem));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)server.elem}))), TestUtils$.MODULE$.createTopic$default$6());
        ((List)this.sent1().map((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerShutdownTest $outer;
            private final ObjectRef producer$1;

            public final Future<RecordMetadata> apply(String value) {
                return ((KafkaProducer)this.producer$1.elem).send(new ProducerRecord(this.$outer.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)value));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$1) {
                return x$1.get();
            }
        });
        ((KafkaServer)server.elem).shutdown();
        this.config().logDirs().foreach((Function1)new Serializable(this, server){
            public static final long serialVersionUID = 0L;
            private final ObjectRef server$1;

            public final void apply(String logDir) {
                File OffsetCheckpointFile = new File(logDir, ((KafkaServer)this.server$1.elem).logManager().RecoveryPointCheckpointFile());
                Assert.assertTrue((boolean)OffsetCheckpointFile.exists());
                Assert.assertTrue((OffsetCheckpointFile.length() > 0L ? 1 : 0) != 0);
            }
            {
                this.server$1 = server$1;
            }
        });
        ((KafkaProducer)producer.elem).close();
        server.elem = new KafkaServer(this.config(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        ((KafkaServer)server.elem).startup();
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)server.elem}))), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        producer.elem = this.createProducer$1((KafkaServer)server.elem);
        KafkaServer qual$1 = (KafkaServer)server.elem;
        SecurityProtocol x$21 = qual$1.boundPort$default$1();
        SimpleConsumer consumer = new SimpleConsumer(this.host(), qual$1.boundPort(x$21), 1000000, 65536, "");
        ByteBufferMessageSet fetchedMessage = null;
        while (fetchedMessage == null || fetchedMessage.validBytes() == 0) {
            FetchResponse fetched = consumer.fetch(new FetchRequestBuilder().addFetch(this.topic(), 0, 0L, 10000).maxWait(0).build());
            fetchedMessage = fetched.messageSet(this.topic(), 0);
        }
        Assert.assertEquals(this.sent1(), (Object)fetchedMessage.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(MessageAndOffset m) {
                return TestUtils$.MODULE$.readString(m.message().payload(), TestUtils$.MODULE$.readString$default$2());
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        long newOffset = ((MessageAndOffset)fetchedMessage.last()).nextOffset();
        ((List)this.sent2().map((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerShutdownTest $outer;
            private final ObjectRef producer$1;

            public final Future<RecordMetadata> apply(String value) {
                return ((KafkaProducer)this.producer$1.elem).send(new ProducerRecord(this.$outer.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)value));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                return x$2.get();
            }
        });
        fetchedMessage = null;
        while (fetchedMessage == null || fetchedMessage.validBytes() == 0) {
            FetchResponse fetched = consumer.fetch(new FetchRequestBuilder().addFetch(this.topic(), 0, newOffset, 10000).build());
            fetchedMessage = fetched.messageSet(this.topic(), 0);
        }
        Assert.assertEquals(this.sent2(), (Object)fetchedMessage.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(MessageAndOffset m) {
                return TestUtils$.MODULE$.readString(m.message().payload(), TestUtils$.MODULE$.readString$default$2());
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
        ((KafkaServer)server.elem).shutdown();
        CoreUtils$.MODULE$.delete(((KafkaServer)server.elem).config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Test
    public void testCleanShutdownWithDeleteTopicEnabled() {
        KafkaConfig newConfig;
        Properties newProps = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        newProps.setProperty("delete.topic.enable", "true");
        KafkaConfig x$22 = newConfig = KafkaConfig$.MODULE$.fromProps(newProps);
        Option x$23 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$24 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$25 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$22, x$24, x$23, x$25);
        server.startup();
        server.shutdown();
        server.awaitShutdown();
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Test
    public void testCleanShutdownAfterFailedStartup() {
        KafkaConfig newConfig;
        Properties newProps = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        newProps.setProperty("zookeeper.connect", "fakehostthatwontresolve:65535");
        KafkaConfig x$26 = newConfig = KafkaConfig$.MODULE$.fromProps(newProps);
        Option x$27 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$28 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$29 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$26, x$28, x$27, x$29);
        try {
            try {
                server.startup();
                throw this.fail("Expected KafkaServer setup to fail, throw exception", new Position("ServerShutdownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            }
            catch (Throwable throwable) {
                throw this.fail(new StringOps(Predef$.MODULE$.augmentString("Expected ZkException during Kafka server starting up but caught a different exception %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable.toString()})), new Position("ServerShutdownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            }
            catch (ZkException zkException) {
                Assert.assertEquals((long)NotRunning$.MODULE$.state(), (long)server.brokerState().currentState());
            }
        }
        finally {
            if (server.brokerState().currentState() != NotRunning$.MODULE$.state()) {
                server.shutdown();
            }
            server.awaitShutdown();
        }
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    public boolean kafka$server$ServerShutdownTest$$isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assert.assertEquals((long)0L, (long)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Thread apply(Object x$3) {
                return (Thread)x$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Thread.class)))).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerShutdownTest $outer;

            public final boolean apply(Thread t) {
                return this.$outer.kafka$server$ServerShutdownTest$$isNonDaemonKafkaThread(t);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    @Test
    public void testConsecutiveShutdown() {
        KafkaServer server = new KafkaServer(this.config(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        try {
            server.startup();
            server.shutdown();
            server.awaitShutdown();
            server.shutdown();
            Assert.assertTrue((boolean)true);
            return;
        }
        catch (Throwable throwable) {
            throw this.fail(new Position("ServerShutdownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        }
    }

    private final KafkaProducer createProducer$1(KafkaServer server) {
        String x$4 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$5 = 5;
        IntegerSerializer x$6 = new IntegerSerializer();
        StringSerializer x$7 = new StringSerializer();
        int x$8 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$9 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$10 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$11 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$12 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$14 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$15 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$16 = TestUtils$.MODULE$.createNewProducer$default$13();
        return TestUtils$.MODULE$.createNewProducer(x$4, x$8, x$9, x$10, x$5, x$11, x$12, x$13, x$14, x$15, x$6, x$7, x$16);
    }

    public ServerShutdownTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.config = null;
        this.host = "localhost";
        this.topic = "test";
        this.sent1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        this.sent2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"more", "messages"}));
    }
}

