/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionMetadata$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponse$;
import kafka.api.ProducerResponseStatus;
import kafka.api.ProducerResponseStatus$;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadata$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.FailedToSendMessageException;
import kafka.common.QueueFullException;
import kafka.common.TopicAndPartition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.AsyncProducerTest$NegativePartitioner$;
import kafka.producer.KeyedMessage;
import kafka.producer.Partitioner;
import kafka.producer.Producer;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.SyncProducer;
import kafka.producer.SyncProducerConfig$;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.Encoder;
import kafka.serializer.NullEncoder;
import kafka.serializer.NullEncoder$;
import kafka.serializer.StringEncoder;
import kafka.serializer.StringEncoder$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.FixedValuePartitioner;
import kafka.utils.FixedValuePartitioner$;
import kafka.utils.IntEncoder;
import kafka.utils.IntEncoder$;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#Q:z]\u000e\u0004&o\u001c3vG\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0005qe>$WoY3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\r\u0011!\u0002\u0001A\u000b\u0003'9+w-\u0019;jm\u0016\u0004\u0016M\u001d;ji&|g.\u001a:\u0014\u0007MAa\u0003\u0005\u0002\u0013/%\u0011\u0001D\u0001\u0002\f!\u0006\u0014H/\u001b;j_:,'\u000f\u0003\u0005\u001b'\t\u0005\t\u0015!\u0003\u001c\u0003\u0015\u0001(o\u001c9t!\tar$D\u0001\u001e\u0015\tqB!A\u0003vi&d7/\u0003\u0002!;\t!b+\u001a:jM&\f'\r\\3Qe>\u0004XM\u001d;jKNDQaD\n\u0005\u0002\t\"\"aI\u0013\u0011\u0005\u0011\u001aR\"\u0001\u0001\t\u000fi\t\u0003\u0013!a\u00017!)qe\u0005C\u0001Q\u0005I\u0001/\u0019:uSRLwN\u001c\u000b\u0004S1\n\u0004CA\u0005+\u0013\tY#BA\u0002J]RDQ!\f\u0014A\u00029\nA\u0001Z1uCB\u0011\u0011bL\u0005\u0003a)\u00111!\u00118z\u0011\u0015\u0011d\u00051\u0001*\u00035qW/\u001c)beRLG/[8og\u001e9A\u0007AA\u0001\u0012\u0003)\u0014a\u0005(fO\u0006$\u0018N^3QCJ$\u0018\u000e^5p]\u0016\u0014\bC\u0001\u00137\r\u001d!\u0002!!A\t\u0002]\u001a\"A\u000e\u0005\t\u000b=1D\u0011A\u001d\u0015\u0003UBqa\u000f\u001c\u0012\u0002\u0013\u0005A(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0002{)\u00121DP\u0016\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u0012\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002G\u0003\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fi\u0001!\u0019!C\u0001\u0011V\t\u0011\nE\u0002K\u001b>k\u0011a\u0013\u0006\u0003\u0019*\t!bY8mY\u0016\u001cG/[8o\u0013\tq5JA\u0002TKF\u0004\"\u0001U+\u000e\u0003ES!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016K\u0001\u0006Qe>\u0004XM\u001d;jKNDa\u0001\u0017\u0001!\u0002\u0013I\u0015A\u00029s_B\u001c\b\u0005C\u0004[\u0001\t\u0007I\u0011A.\u0002\u000f\r|gNZ5hgV\tA\fE\u0002K\u001bv\u0003\"AX1\u000e\u0003}S!\u0001\u0019\u0003\u0002\rM,'O^3s\u0013\t\u0011wLA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u00023\u0001A\u0003%A,\u0001\u0005d_:4\u0017nZ:!\u0011\u001d1\u0007A1A\u0005\u0002\u001d\f!B\u0019:pW\u0016\u0014H*[:u+\u0005A\u0007CA5m\u001d\tI!.\u0003\u0002l\u0015\u00051\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tY'\u0002\u0003\u0004q\u0001\u0001\u0006I\u0001[\u0001\fEJ|7.\u001a:MSN$\b\u0005C\u0003s\u0001\u0011\u00051/A\u000buKN$\bK]8ek\u000e,'/U;fk\u0016\u001c\u0016N_3\u0015\u0003Q\u0004\"!C;\n\u0005YT!\u0001B+oSRD#!\u001d=\u0011\u0005etX\"\u0001>\u000b\u0005md\u0018!\u00026v]&$(\"A?\u0002\u0007=\u0014x-\u0003\u0002\u0000u\n!A+Z:u\u0011\u0019\t\u0019\u0001\u0001C\u0001g\u00061B/Z:u!J|G-^2f\u0003\u001a$XM]\"m_N,G\rK\u0002\u0002\u0002aDa!!\u0003\u0001\t\u0003\u0019\u0018!\u0004;fgR\u0014\u0015\r^2i'&TX\rK\u0002\u0002\baDa!a\u0004\u0001\t\u0003\u0019\u0018\u0001\u0006;fgR\fV/Z;f)&lW-\u0012=qSJ,G\rK\u0002\u0002\u000eaDa!!\u0006\u0001\t\u0003\u0019\u0018!\b;fgR\u0004\u0016M\u001d;ji&|g.\u00118e\u0007>dG.\u0019;f\u000bZ,g\u000e^:)\u0007\u0005M\u0001\u0010\u0003\u0004\u0002\u001c\u0001!\ta]\u0001\u0014i\u0016\u001cHoU3sS\u0006d\u0017N_3Fm\u0016tGo\u001d\u0015\u0004\u00033A\bBBA\u0011\u0001\u0011\u00051/\u0001\u000buKN$\u0018J\u001c<bY&$\u0007+\u0019:uSRLwN\u001c\u0015\u0004\u0003?A\bBBA\u0014\u0001\u0011\u00051/\u0001\u0007uKN$hj\u001c\"s_.,'\u000fK\u0002\u0002&aDa!!\f\u0001\t\u0003\u0019\u0018a\u0006;fgRLenY8na\u0006$\u0018N\u00197f\u000b:\u001cw\u000eZ3sQ\r\tY\u0003\u001f\u0005\u0007\u0003g\u0001A\u0011A:\u0002+Q,7\u000f\u001e*b]\u0012|W\u000eU1si&$\u0018n\u001c8fe\"\u001a\u0011\u0011\u0007=\t\r\u0005e\u0002\u0001\"\u0001t\u0003a!Xm\u001d;GC&dW\rZ*f]\u0012\u0014V\r\u001e:z\u0019><\u0017n\u0019\u0015\u0004\u0003oA\bBBA \u0001\u0011\u00051/\u0001\tuKN$(*\u0019<b!J|G-^2fe\"\u001a\u0011Q\b=\t\r\u0005\u0015\u0003\u0001\"\u0001t\u0003a!Xm\u001d;J]Z\fG.\u001b3D_:4\u0017nZ;sCRLwN\u001c\u0015\u0004\u0003\u0007B\bbBA&\u0001\u0011\u0005\u0011QJ\u0001\u000fO\u0016$\bK]8ek\u000e,G)\u0019;b)\u0011\ty%a\u001b\u0011\r\u0005E\u0013\u0011MA3\u001d\u0011\t\u0019&!\u0018\u000f\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\u0007\u0003\u0019a$o\\8u}%\t1\"C\u0002\u0002`)\tq\u0001]1dW\u0006<W-C\u0002O\u0003GR1!a\u0018\u000b!\u0015\u0011\u0012q\r5i\u0013\r\tIG\u0001\u0002\r\u0017\u0016LX\rZ'fgN\fw-\u001a\u0005\b\u0003[\nI\u00051\u0001*\u0003\u001dqWI^3oiNDq!!\u001d\u0001\t\u0013\t\u0019(\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCRa\u0011QOAA\u0003\u000b\u000b9)a#\u0002\u0010B!\u0011qOA?\u001b\t\tIHC\u0002\u0002|\u0011\t1!\u00199j\u0013\u0011\ty(!\u001f\u0003\u001bQ{\u0007/[2NKR\fG-\u0019;b\u0011\u001d\t\u0019)a\u001cA\u0002!\fQ\u0001^8qS\u000eDaaJA8\u0001\u0004I\u0003bBAE\u0003_\u0002\r!K\u0001\tEJ|7.\u001a:JI\"9\u0011QRA8\u0001\u0004A\u0017A\u00032s_.,'\u000fS8ti\"9\u0011\u0011SA8\u0001\u0004I\u0013A\u00032s_.,'\u000fU8si\"9\u0011\u0011\u000f\u0001\u0005\n\u0005UE\u0003DA;\u0003/\u000bI*!(\u0002 \u0006\u0005\u0006bBAB\u0003'\u0003\r\u0001\u001b\u0005\bO\u0005M\u0005\u0019AAN!\u0015\t\t&!\u0019*\u0011\u001d\tI)a%A\u0002%Bq!!$\u0002\u0014\u0002\u0007\u0001\u000eC\u0004\u0002\u0012\u0006M\u0005\u0019A\u0015\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\u0006iQ.Z:tC\u001e,7\u000fV8TKR$B!!+\u00026B!\u00111VAY\u001b\t\tiKC\u0002\u00020\u0012\tq!\\3tg\u0006<W-\u0003\u0003\u00024\u00065&\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+G\u000f\u0003\u0005\u00028\u0006\r\u0006\u0019AA]\u0003!iWm]:bO\u0016\u001c\b#BA)\u0003CB\u0007bBAS\u0001\u0011\u0005\u0011Q\u0018\u000b\u0007\u0003S\u000by,a4\t\u0011\u0005\u0005\u00171\u0018a\u0001\u0003\u0007\f1a[3z!\u0015I\u0011QYAe\u0013\r\t9M\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0013\u0005-\u0017bAAg\u0015\t!!)\u001f;f\u0011!\t9,a/A\u0002\u0005E\u0007CBA)\u0003C\n\u0019\rK\u0004\u0001\u0003+\fY.a8\u0011\u0007%\t9.C\u0002\u0002Z*\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\ti.A%UQ&\u001c\b\u0005^3ti\u0002B\u0017m\u001d\u0011cK\u0016t\u0007\u0005Z3qe\u0016\u001c\u0017\r^3eA\u0005tG\rI5uA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012\u0004\u0013N\u001c\u0011bA\u0019,H/\u001e:fAI,G.Z1tK:\n#!!9\u0002\u0011Ar\u0013\u0007\r\u00181]A\u0002")
public class AsyncProducerTest {
    private final Seq<Properties> props;
    private final Seq<KafkaConfig> configs;
    private final String brokerList;
    private volatile AsyncProducerTest$NegativePartitioner$ NegativePartitioner$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AsyncProducerTest$NegativePartitioner$ NegativePartitioner$lzycompute() {
        AsyncProducerTest asyncProducerTest = this;
        synchronized (asyncProducerTest) {
            if (this.NegativePartitioner$module != null) return this.NegativePartitioner$module;
            this.NegativePartitioner$module = new AsyncProducerTest$NegativePartitioner$(this);
            return this.NegativePartitioner$module;
        }
    }

    public AsyncProducerTest$NegativePartitioner$ NegativePartitioner() {
        return this.NegativePartitioner$module == null ? this.NegativePartitioner$lzycompute() : this.NegativePartitioner$module;
    }

    public Seq<Properties> props() {
        return this.props;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String brokerList() {
        return this.brokerList;
    }

    @Test
    public void testProducerQueueSize() {
        EventHandler<String, String> mockEventHandler = new EventHandler<String, String>(this){

            public void handle(Seq<KeyedMessage<String, String>> events) {
                Thread.sleep(500L);
            }

            public void close() {
            }
        };
        Properties props = new Properties();
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("metadata.broker.list", this.brokerList());
        props.put("producer.type", "async");
        props.put("queue.buffering.max.messages", "10");
        props.put("batch.num.messages", "1");
        props.put("queue.enqueue.timeout.ms", "0");
        ProducerConfig config = new ProducerConfig(props);
        Seq<KeyedMessage<String, String>> produceData2 = this.getProduceData(12);
        try (Producer producer = new Producer(config, (EventHandler)mockEventHandler);){
            try {
                producer.send(produceData2);
                Assert.fail((String)"Queue should be full");
            }
            catch (QueueFullException queueFullException) {}
        }
    }

    @Test
    public void testProduceAfterClosed() {
        Seq<KeyedMessage<String, String>> produceData2 = this.getProduceData(10);
        Producer producer = TestUtils$.MODULE$.createProducer(this.brokerList(), StringEncoder.class.getName(), TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5());
        producer.close();
        try {
            producer.send(produceData2);
            Assert.fail((String)"should complain that producer is already closed");
        }
        catch (ProducerClosedException producerClosedException) {
            // empty catch block
        }
    }

    @Test
    public void testBatchSize() {
        Seq<KeyedMessage<String, String>> producerDataList = this.getProduceData(10);
        DefaultEventHandler mockHandler = (DefaultEventHandler)EasyMock.createStrictMock(DefaultEventHandler.class);
        mockHandler.handle((Seq)producerDataList.take(5));
        EasyMock.expectLastCall();
        mockHandler.handle((Seq)producerDataList.takeRight(5));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockHandler});
        LinkedBlockingQueue queue = new LinkedBlockingQueue(10);
        ProducerSendThread producerSendThread = new ProducerSendThread("thread1", queue, (EventHandler)mockHandler, Integer.MAX_VALUE, 5, "");
        producerSendThread.start();
        producerDataList.foreach((Function1)new Serializable(this, queue){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue queue$1;

            public final void apply(KeyedMessage<String, String> producerData) {
                this.queue$1.put(producerData);
            }
            {
                this.queue$1 = queue$1;
            }
        });
        producerSendThread.shutdown();
        EasyMock.verify((Object[])new Object[]{mockHandler});
    }

    @Test
    public void testQueueTimeExpired() {
        Seq<KeyedMessage<String, String>> producerDataList = this.getProduceData(2);
        DefaultEventHandler mockHandler = (DefaultEventHandler)EasyMock.createStrictMock(DefaultEventHandler.class);
        mockHandler.handle(producerDataList);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockHandler});
        int queueExpirationTime = 200;
        LinkedBlockingQueue queue = new LinkedBlockingQueue(10);
        ProducerSendThread producerSendThread = new ProducerSendThread("thread1", queue, (EventHandler)mockHandler, (long)queueExpirationTime, 5, "");
        producerSendThread.start();
        producerDataList.foreach((Function1)new Serializable(this, queue){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue queue$2;

            public final void apply(KeyedMessage<String, String> producerData) {
                this.queue$2.put(producerData);
            }
            {
                this.queue$2 = queue$2;
            }
        });
        Thread.sleep(queueExpirationTime + 100);
        EasyMock.verify((Object[])new Object[]{mockHandler});
        producerSendThread.shutdown();
    }

    @Test
    public void testPartitionAndCollateEvents() {
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Message("msg1".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)-99), (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Message("msg2".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Message("msg3".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)-101), (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Message("msg4".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)4), (Object)new Message("msg5".getBytes()))}));
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        BrokerEndPoint broker1 = new BrokerEndPoint(0, "localhost", 9092);
        BrokerEndPoint broker2 = new BrokerEndPoint(1, "localhost", 9093);
        PartitionMetadata partition1Metadata = new PartitionMetadata(0, (Option)new Some((Object)broker1), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{broker1, broker2})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
        PartitionMetadata partition2Metadata = new PartitionMetadata(1, (Option)new Some((Object)broker2), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{broker1, broker2})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
        TopicMetadata topic1Metadata = new TopicMetadata("topic1", (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionMetadata[]{partition1Metadata, partition2Metadata})), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        TopicMetadata topic2Metadata = new TopicMetadata("topic2", (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionMetadata[]{partition1Metadata, partition2Metadata})), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        topicPartitionInfos.put((Object)"topic2", (Object)topic2Metadata);
        Partitioner intPartitioner = new Partitioner(this){

            public int partition(Object key, int numPartitions) {
                return BoxesRunTime.unboxToInt((Object)key) % numPartitions;
            }
        };
        ProducerConfig config = new ProducerConfig(props);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, intPartitioner, null, (Encoder)new IntEncoder(IntEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
        ArrayBuffer topic1Broker1Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Message("msg1".getBytes())), new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Message("msg3".getBytes()))}));
        ArrayBuffer topic1Broker2Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)-101), (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Message("msg4".getBytes()))}));
        ArrayBuffer topic2Broker1Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)4), (Object)new Message("msg5".getBytes()))}));
        ArrayBuffer topic2Broker2Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)-99), (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Message("msg2".getBytes()))}));
        Some expectedResult = new Some((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)topic1Broker1Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)topic2Broker1Data)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)topic1Broker2Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)topic2Broker2Data)})))})));
        Option actualResult = handler.partitionAndCollate((Seq)producerDataList);
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testSerializeEvents() {
        Seq produceData2 = (Seq)TestUtils$.MODULE$.getMsgStrings(5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KeyedMessage<String, String> apply(String m) {
                return new KeyedMessage("topic1", (Object)m);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, null, (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
        Seq serializedData = handler.serialize(produceData2);
        Seq deserializedData = (Seq)serializedData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KeyedMessage<String, String> apply(KeyedMessage<String, Message> d) {
                return new KeyedMessage(d.topic(), (Object)TestUtils$.MODULE$.readString(((Message)d.message()).payload(), TestUtils$.MODULE$.readString$default$2()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq streamedSerializedData = handler.serialize((Seq)package$.MODULE$.Stream().apply(produceData2));
        Seq deserializedStreamData = (Seq)streamedSerializedData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KeyedMessage<String, String> apply(KeyedMessage<String, Message> d) {
                return new KeyedMessage(d.topic(), (Object)TestUtils$.MODULE$.readString(((Message)d.message()).payload(), TestUtils$.MODULE$.readString$default$2()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.checkEquals(produceData2.iterator(), deserializedData.iterator());
        TestUtils$.MODULE$.checkEquals(produceData2.iterator(), deserializedStreamData.iterator());
    }

    @Test
    public void testInvalidPartition() {
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)"key1", (Object)new Message("msg1".getBytes()))}));
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, (Partitioner)new NegativePartitioner(this.NegativePartitioner().$lessinit$greater$default$1()), null, null, producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
        try {
            handler.partitionAndCollate((Seq)producerDataList);
        }
        catch (Throwable throwable) {
            Assert.fail((String)"Should not throw any exception");
        }
    }

    @Test
    public void testNoBroker() {
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = new TopicMetadata("topic1", (Seq)Seq$.MODULE$.empty(), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)"msg1")}));
        DefaultEventHandler handler = new DefaultEventHandler(config, null, (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
        try {
            handler.handle((Seq)producerDataList);
            Assert.fail((String)"Should fail with FailedToSendMessageException");
        }
        catch (FailedToSendMessageException failedToSendMessageException) {
            // empty catch block
        }
    }

    @Test
    public void testIncompatibleEncoder() {
        Properties props = new Properties();
        props.put("message.send.max.retries", "0");
        String x$20 = this.brokerList();
        String x$21 = DefaultEncoder.class.getName();
        String x$22 = DefaultEncoder.class.getName();
        Properties x$23 = props;
        String x$24 = TestUtils$.MODULE$.createProducer$default$4();
        try (Producer producer = TestUtils$.MODULE$.createProducer(x$20, x$21, x$22, x$24, x$23);){
            try {
                producer.send(this.getProduceData(1));
                Assert.fail((String)"Should fail with ClassCastException due to incompatible Encoder");
            }
            catch (ClassCastException classCastException) {}
        }
    }

    @Test
    public void testRandomPartitioner() {
        Option option;
        block4: {
            block3: {
                block2: {
                    Option partitionedDataOpt;
                    Properties props = new Properties();
                    props.put("metadata.broker.list", this.brokerList());
                    ProducerConfig config = new ProducerConfig(props);
                    TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
                    TopicMetadata topic2Metadata = this.getTopicMetadata("topic2", 0, 0, "localhost", 9092);
                    HashMap topicPartitionInfos = new HashMap();
                    topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
                    topicPartitionInfos.put((Object)"topic2", (Object)topic2Metadata);
                    ProducerPool producerPool = new ProducerPool(config);
                    DefaultEventHandler handler = new DefaultEventHandler(config, null, null, null, producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
                    ArrayBuffer producerDataList = new ArrayBuffer();
                    producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)new Message("msg1".getBytes()))}));
                    producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)new Message("msg2".getBytes()))}));
                    producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)new Message("msg3".getBytes()))}));
                    option = partitionedDataOpt = handler.partitionAndCollate((Seq)producerDataList);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Map partitionedData = (Map)some.x();
                    partitionedData.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> check$ifrefutable$1) {
                            Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> tuple2 = check$ifrefutable$1;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> x$2) {
                            Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> tuple2 = x$2;
                            if (tuple2 != null) {
                                scala.collection.mutable.Map dataPerBroker = (scala.collection.mutable.Map)tuple2._2();
                                dataPerBroker.withFilter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> check$ifrefutable$2) {
                                        TopicAndPartition topicAndPartition;
                                        Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> tuple2 = check$ifrefutable$2;
                                        boolean bl = tuple2 != null && (topicAndPartition = (TopicAndPartition)tuple2._1()) != null;
                                        return bl;
                                    }
                                }).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> x$1) {
                                        TopicAndPartition topicAndPartition;
                                        Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> tuple2 = x$1;
                                        if (tuple2 != null && (topicAndPartition = (TopicAndPartition)tuple2._1()) != null) {
                                            int partitionId = topicAndPartition.partition();
                                            Assert.assertTrue((partitionId == 0 ? 1 : 0) != 0);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Assert.fail((String)"Failed to collate requests by topic, partition");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    @Test
    public void testFailedSendRetryLogic() {
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        props.put("request.required.acks", "1");
        props.put("serializer.class", StringEncoder.class.getName().toString());
        props.put("key.serializer.class", NullEncoder.class.getName().toString());
        props.put("producer.num.retries", ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        ProducerConfig config = new ProducerConfig(props);
        String topic1 = "topic1";
        TopicMetadata topic1Metadata = this.getTopicMetadata(topic1, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}), 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        Seq<String> msgs = TestUtils$.MODULE$.getMsgStrings(2);
        List x$25 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}));
        List x$26 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ByteBufferMessageSet x$27 = this.messagesToSet(msgs);
        int x$28 = 1;
        int x$29 = 11;
        int x$30 = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        String x$31 = SyncProducerConfig$.MODULE$.DefaultClientId();
        ProducerRequest request1 = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$25, (Seq<Object>)x$26, x$27, x$28, x$30, x$29, x$31);
        List x$32 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}));
        List x$33 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ByteBufferMessageSet x$34 = this.messagesToSet(msgs);
        int x$35 = 1;
        int x$36 = 17;
        int x$37 = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        String x$38 = SyncProducerConfig$.MODULE$.DefaultClientId();
        ProducerRequest request2 = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$32, (Seq<Object>)x$33, x$34, x$35, x$37, x$36, x$38);
        ProducerResponse response1 = new ProducerResponse(0, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicAndPartition("topic1", 0), (Object)new ProducerResponseStatus(Errors.NOT_LEADER_FOR_PARTITION.code(), 0L, ProducerResponseStatus$.MODULE$.apply$default$3())), new Tuple2((Object)new TopicAndPartition("topic1", 1), (Object)new ProducerResponseStatus(Errors.NONE.code(), 0L, ProducerResponseStatus$.MODULE$.apply$default$3()))})), ProducerResponse$.MODULE$.apply$default$3(), ProducerResponse$.MODULE$.apply$default$4());
        String x$39 = topic1;
        int x$40 = 0;
        ByteBufferMessageSet x$41 = this.messagesToSet(msgs);
        int x$42 = 1;
        int x$43 = 21;
        int x$44 = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        String x$45 = SyncProducerConfig$.MODULE$.DefaultClientId();
        ProducerRequest request3 = TestUtils$.MODULE$.produceRequest(x$39, x$40, x$41, x$42, x$44, x$43, x$45);
        ProducerResponse response2 = new ProducerResponse(0, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicAndPartition("topic1", 0), (Object)new ProducerResponseStatus(Errors.NONE.code(), 0L, ProducerResponseStatus$.MODULE$.apply$default$3()))})), ProducerResponse$.MODULE$.apply$default$3(), ProducerResponse$.MODULE$.apply$default$4());
        SyncProducer mockSyncProducer = (SyncProducer)EasyMock.createMock(SyncProducer.class);
        EasyMock.expect((Object)mockSyncProducer.config()).andReturn(EasyMock.anyObject()).anyTimes();
        EasyMock.expect((Object)mockSyncProducer.send(request1)).andThrow((Throwable)new RuntimeException());
        EasyMock.expect((Object)mockSyncProducer.send(request2)).andReturn((Object)response1);
        EasyMock.expect((Object)mockSyncProducer.send(request3)).andReturn((Object)response2);
        EasyMock.replay((Object[])new Object[]{mockSyncProducer});
        ProducerPool producerPool = (ProducerPool)EasyMock.createMock(ProducerPool.class);
        EasyMock.expect((Object)producerPool.getProducer(0)).andReturn((Object)mockSyncProducer).times(4);
        producerPool.close();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{producerPool});
        Time time = new Time(this){

            public long hiResClockMs() {
                return Time.class.hiResClockMs((Time)this);
            }

            public long nanoseconds() {
                return 0L;
            }

            public long milliseconds() {
                return 0L;
            }

            public void sleep(long ms) {
            }
            {
                Time.class.$init$((Time)this);
            }
        };
        DefaultEventHandler handler = new DefaultEventHandler(config, (Partitioner)new FixedValuePartitioner(FixedValuePartitioner$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new NullEncoder(NullEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos, time);
        Seq data = (Seq)((TraversableLike)msgs.map((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;

            public final KeyedMessage<Object, String> apply(String m) {
                return new KeyedMessage(this.topic1$1, (Object)BoxesRunTime.boxToInteger((int)0), (Object)m);
            }
            {
                this.topic1$1 = topic1$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)msgs.map((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;

            public final KeyedMessage<Object, String> apply(String m) {
                return new KeyedMessage(this.topic1$1, (Object)BoxesRunTime.boxToInteger((int)1), (Object)m);
            }
            {
                this.topic1$1 = topic1$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        handler.handle(data);
        handler.close();
        EasyMock.verify((Object[])new Object[]{mockSyncProducer});
        EasyMock.verify((Object[])new Object[]{producerPool});
    }

    @Test
    public void testJavaProducer() {
        String topic = "topic1";
        Seq<String> msgs = TestUtils$.MODULE$.getMsgStrings(5);
        Seq scalaProducerData = (Seq)msgs.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final KeyedMessage<String, String> apply(String m) {
                return new KeyedMessage(this.topic$1, (Object)m);
            }
            {
                this.topic$1 = topic$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        java.util.List javaProducerData = JavaConversions$.MODULE$.seqAsJavaList(scalaProducerData);
        Producer mockScalaProducer = (Producer)EasyMock.createMock(Producer.class);
        mockScalaProducer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{(KeyedMessage)scalaProducerData.head()}));
        EasyMock.expectLastCall();
        mockScalaProducer.send(scalaProducerData);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockScalaProducer});
        kafka.javaapi.producer.Producer javaProducer = new kafka.javaapi.producer.Producer(mockScalaProducer);
        javaProducer.send((KeyedMessage)javaProducerData.get(0));
        javaProducer.send(javaProducerData);
        EasyMock.verify((Object[])new Object[]{mockScalaProducer});
    }

    @Test
    public void testInvalidConfiguration() {
        Properties props = new Properties();
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("producer.type", "async");
        try {
            new ProducerConfig(props);
            Assert.fail((String)"should complain about wrong config");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public Seq<KeyedMessage<String, String>> getProduceData(int nEvents) {
        void var2_2;
        ArrayBuffer producerDataList = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nEvents).foreach$mVc$sp((Function1)new Serializable(this, producerDataList){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer producerDataList$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.producerDataList$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", null, (Object)new StringBuilder().append((Object)"msg").append((Object)BoxesRunTime.boxToInteger((int)i)).toString())}));
            }
            {
                this.producerDataList$1 = producerDataList$1;
            }
        });
        return var2_2;
    }

    private TopicMetadata getTopicMetadata(String topic, int partition, int brokerId, String brokerHost, int brokerPort) {
        return this.getTopicMetadata(topic, (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{partition})), brokerId, brokerHost, brokerPort);
    }

    private TopicMetadata getTopicMetadata(String topic, Seq<Object> partition, int brokerId, String brokerHost, int brokerPort) {
        BrokerEndPoint broker1 = new BrokerEndPoint(brokerId, brokerHost, brokerPort);
        return new TopicMetadata(topic, (Seq)partition.map((Function1)new Serializable(this, broker1){
            public static final long serialVersionUID = 0L;
            private final BrokerEndPoint broker1$1;

            public final PartitionMetadata apply(int x$3) {
                return new PartitionMetadata(x$3, (Option)new Some((Object)this.broker1$1), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{this.broker1$1})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.broker1$1 = broker1$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public ByteBufferMessageSet messagesToSet(Seq<String> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messages2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(String m) {
                return new Message(m.getBytes(), 0L, Message$.MODULE$.MagicValue_V1());
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public ByteBufferMessageSet messagesToSet(byte[] key, Seq<byte[]> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messages2.map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final byte[] key$1;

            public final Message apply(byte[] m) {
                byte[] x$46 = this.key$1;
                byte[] x$47 = m;
                long x$48 = 0L;
                byte x$49 = Message$.MODULE$.MagicValue_V1();
                return new Message(x$47, x$46, x$48, x$49);
            }
            {
                this.key$1 = key$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public AsyncProducerTest() {
        Properties[] propertiesArray = new Properties[1];
        int x$4 = 1;
        String x$5 = "127.0.0.1:1";
        int x$6 = 65534;
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$11 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$17 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$18 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$19 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        propertiesArray[0] = TestUtils$.MODULE$.createBrokerConfig(x$4, x$5, x$7, x$8, x$6, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
        this.props = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])propertiesArray));
        this.configs = (Seq)this.props().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.brokerList = ((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KafkaConfig c) {
                return Utils.formatAddress((String)c.hostName(), (Integer)c.port());
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public class NegativePartitioner
    implements Partitioner {
        public int partition(Object data, int numPartitions) {
            return -1;
        }

        public /* synthetic */ AsyncProducerTest kafka$producer$AsyncProducerTest$NegativePartitioner$$$outer() {
            return AsyncProducerTest.this;
        }

        public NegativePartitioner(VerifiableProperties props) {
            if (AsyncProducerTest.this == null) {
                throw null;
            }
        }
    }
}

