/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.BaseQuotaTest;
import kafka.server.ConfigEntityName$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaId;
import kafka.server.QuotaId$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.junit.Before;
import scala.Option;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u000f\t)Rk]3s\u00072LWM\u001c;JIF+x\u000e^1UKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!AA\u0007CCN,\u0017+^8uCR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000bE\u0001A\u0011\u000b\n\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#A\n\u0011\u0005QqR\"A\u000b\u000b\u0005Y9\u0012\u0001\u00039s_R|7m\u001c7\u000b\u0005aI\u0012AB2p[6|gN\u0003\u0002\u00065)\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0013\tyRC\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"A\u0011\u0005\u0001EC\u0002\u0013E#%\u0001\bueV\u001cHo\u0015;pe\u00164\u0015\u000e\\3\u0016\u0003\r\u00022\u0001J\u0014*\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#\u0001B*p[\u0016\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0005%|'\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a-\u0012AAR5mK\"A!\u0007\u0001E\u0001B\u0003&1%A\bueV\u001cHo\u0015;pe\u00164\u0015\u000e\\3!\u0011\u001d!\u0004A1A\u0005BU\nQ\"^:feB\u0013\u0018N\\2ja\u0006dW#\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ej\u0013\u0001\u00027b]\u001eL!a\u000f\u001d\u0003\rM#(/\u001b8h\u0011\u0019i\u0004\u0001)A\u0005m\u0005qQo]3s!JLgnY5qC2\u0004\u0003\"B \u0001\t\u0003\u0002\u0015a\u00049s_\u0012,8-\u001a:Rk>$\u0018-\u00133\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001\u0012\u0003\u0002\rM,'O^3s\u0013\t15IA\u0004Rk>$\u0018-\u00133\t\u000b!\u0003A\u0011\t!\u0002\u001f\r|gn];nKJ\fVo\u001c;b\u0013\u0012DQA\u0013\u0001\u0005B-\u000bQa]3u+B$\u0012\u0001\u0014\t\u0003I5K!AT\u0013\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0013B\u0003\"!\u0015+\u000e\u0003IS!a\u0015\u000f\u0002\u000b),h.\u001b;\n\u0005U\u0013&A\u0002\"fM>\u0014X\rC\u0003X\u0001\u0011\u0005\u0003,\u0001\bpm\u0016\u0014(/\u001b3f#V|G/Y:\u0015\u00071Kf\fC\u0003[-\u0002\u00071,A\u0007qe>$WoY3s#V|G/\u0019\t\u0003IqK!!X\u0013\u0003\t1{gn\u001a\u0005\u0006?Z\u0003\raW\u0001\u000eG>t7/^7feF+x\u000e^1\t\u000b\u0005\u0004A\u0011I&\u0002)I,Wn\u001c<f#V|G/Y(wKJ\u0014\u0018\u000eZ3t\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0003M)\b\u000fZ1uKF+x\u000e^1Pm\u0016\u0014(/\u001b3f)\u0011aU\r\u001c8\t\u000bQ\u0012\u0007\u0019\u00014\u0011\u0005\u001dTgB\u0001\u0013i\u0013\tIW%\u0001\u0004Qe\u0016$WMZ\u0005\u0003w-T!![\u0013\t\u000b5\u0014\u0007\u0019\u00014\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012DQa\u001c2A\u0002A\f!\u0002\u001d:pa\u0016\u0014H/[3t!\t\tH/D\u0001s\u0015\t\u0019X&\u0001\u0003vi&d\u0017BA;s\u0005)\u0001&o\u001c9feRLWm\u001d")
public class UserClientIdQuotaTest
extends BaseQuotaTest {
    private Some<File> trustStoreFile;
    private final String userPrincipal;
    private volatile boolean bitmap$0;

    private Some trustStoreFile$lzycompute() {
        UserClientIdQuotaTest userClientIdQuotaTest = this;
        synchronized (userClientIdQuotaTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
            return this.trustStoreFile;
        }
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SSL;
    }

    public Some<File> trustStoreFile() {
        return this.bitmap$0 ? this.trustStoreFile : this.trustStoreFile$lzycompute();
    }

    @Override
    public String userPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public QuotaId producerQuotaId() {
        return new QuotaId((Option)new Some((Object)QuotaId$.MODULE$.sanitize(this.userPrincipal())), (Option)new Some((Object)this.producerClientId()));
    }

    @Override
    public QuotaId consumerQuotaId() {
        return new QuotaId((Option)new Some((Object)QuotaId$.MODULE$.sanitize(this.userPrincipal())), (Option)new Some((Object)this.consumerClientId()));
    }

    @Override
    @Before
    public void setUp() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.SslClientAuthProp(), "required");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        super.setUp();
        Properties defaultProps = this.quotaProperties(this.defaultProducerQuota(), this.defaultConsumerQuota());
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), defaultProps);
        this.waitForQuotaUpdate(this.defaultProducerQuota(), this.defaultConsumerQuota());
    }

    @Override
    public void overrideQuotas(long producerQuota, long consumerQuota) {
        Properties producerProps = new Properties();
        producerProps.setProperty(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        this.updateQuotaOverride(this.userPrincipal(), this.producerClientId(), producerProps);
        Properties consumerProps = new Properties();
        consumerProps.setProperty(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        this.updateQuotaOverride(this.userPrincipal(), this.consumerClientId(), consumerProps);
    }

    @Override
    public void removeQuotaOverrides() {
        Properties emptyProps = new Properties();
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize(this.userPrincipal())).append((Object)"/clients/").append((Object)this.producerClientId()).toString(), emptyProps);
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize(this.userPrincipal())).append((Object)"/clients/").append((Object)this.consumerClientId()).toString(), emptyProps);
    }

    private void updateQuotaOverride(String userPrincipal, String clientId, Properties properties) {
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize(userPrincipal)).append((Object)"/clients/").append((Object)clientId).toString(), properties);
    }

    public UserClientIdQuotaTest() {
        this.userPrincipal = "O=A client,CN=localhost";
    }
}

