/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.config.ConfigException;

public class MockProducerInterceptor
implements ClusterResourceListener,
ProducerInterceptor<String, String> {
    public static final AtomicInteger INIT_COUNT = new AtomicInteger(0);
    public static final AtomicInteger CLOSE_COUNT = new AtomicInteger(0);
    public static final AtomicInteger ONSEND_COUNT = new AtomicInteger(0);
    public static final AtomicInteger ON_SUCCESS_COUNT = new AtomicInteger(0);
    public static final AtomicInteger ON_ERROR_COUNT = new AtomicInteger(0);
    public static final AtomicInteger ON_ERROR_WITH_METADATA_COUNT = new AtomicInteger(0);
    public static final AtomicReference<ClusterResource> CLUSTER_META = new AtomicReference();
    public static final ClusterResource NO_CLUSTER_ID = new ClusterResource("no_cluster_id");
    public static final AtomicReference<ClusterResource> CLUSTER_ID_BEFORE_ON_ACKNOWLEDGEMENT = new AtomicReference<ClusterResource>(NO_CLUSTER_ID);
    public static final String APPEND_STRING_PROP = "mock.interceptor.append";
    private String appendStr;

    public MockProducerInterceptor() {
        INIT_COUNT.incrementAndGet();
    }

    public void configure(Map<String, ?> configs) {
        Object clientIdValue;
        Object o = configs.get(APPEND_STRING_PROP);
        if (o == null) {
            throw new ConfigException("Mock producer interceptor expects configuration mock.interceptor.append");
        }
        if (o != null && o instanceof String) {
            this.appendStr = (String)o;
        }
        if ((clientIdValue = configs.get("client.id")) == null) {
            throw new ConfigException("Mock producer interceptor expects configuration client.id");
        }
    }

    public ProducerRecord<String, String> onSend(ProducerRecord<String, String> record) {
        ONSEND_COUNT.incrementAndGet();
        return new ProducerRecord(record.topic(), record.partition(), record.key(), (Object)((String)record.value()).concat(this.appendStr));
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
        CLUSTER_ID_BEFORE_ON_ACKNOWLEDGEMENT.compareAndSet(NO_CLUSTER_ID, CLUSTER_META.get());
        if (exception != null) {
            ON_ERROR_COUNT.incrementAndGet();
            if (metadata != null) {
                ON_ERROR_WITH_METADATA_COUNT.incrementAndGet();
            }
        } else if (metadata != null) {
            ON_SUCCESS_COUNT.incrementAndGet();
        }
    }

    public void close() {
        CLOSE_COUNT.incrementAndGet();
    }

    public static void resetCounters() {
        INIT_COUNT.set(0);
        CLOSE_COUNT.set(0);
        ONSEND_COUNT.set(0);
        ON_SUCCESS_COUNT.set(0);
        ON_ERROR_COUNT.set(0);
        ON_ERROR_WITH_METADATA_COUNT.set(0);
        CLUSTER_META.set(null);
        CLUSTER_ID_BEFORE_ON_ACKNOWLEDGEMENT.set(NO_CLUSTER_ID);
    }

    public void onUpdate(ClusterResource clusterResource) {
        CLUSTER_META.set(clusterResource);
    }
}

