/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSchemaAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final long serialVersionUID = 234L;
    public static final String FILE_NAME_IS_REQUIRED = "FileName is required";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final Logger log = LoggerFactory.getLogger(XMLSchemaAssertion.class);
    public static final String XSD_FILENAME_KEY = "xmlschema_assertion_filename";

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        String resultData = response.getResponseDataAsString();
        if (resultData.length() == 0) {
            return result.setResultForNull();
        }
        String xsdFileName = this.getXsdFileName();
        log.debug("xmlString: {}, xsdFileName: {}", (Object)resultData, (Object)xsdFileName);
        if (xsdFileName == null || xsdFileName.length() == 0) {
            result.setResultForFailure(FILE_NAME_IS_REQUIRED);
        } else {
            this.setSchemaResult(result, resultData, xsdFileName);
        }
        return result;
    }

    public void setXsdFileName(String xmlSchemaFileName) throws IllegalArgumentException {
        this.setProperty(XSD_FILENAME_KEY, xmlSchemaFileName);
    }

    public String getXsdFileName() {
        return this.getPropertyAsString(XSD_FILENAME_KEY);
    }

    private void setSchemaResult(AssertionResult result, String xmlStr, String xsdFileName) {
        try {
            DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
            parserFactory.setValidating(true);
            parserFactory.setNamespaceAware(true);
            parserFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            parserFactory.setAttribute(JAXP_SCHEMA_SOURCE, xsdFileName);
            DocumentBuilder parser = parserFactory.newDocumentBuilder();
            parser.setErrorHandler(new SAXErrorHandler(result));
            parser.parse(new InputSource(new StringReader(xmlStr)));
        }
        catch (SAXParseException e) {
            if (!result.isError() && !result.isFailure()) {
                result.setError(true);
                result.setFailureMessage(XMLSchemaAssertion.errorDetails(e));
            }
        }
        catch (SAXException e) {
            if (log.isWarnEnabled()) {
                log.warn(e.toString());
            }
            result.setResultForFailure(e.getMessage());
        }
        catch (IOException e) {
            log.warn("IO error", (Throwable)e);
            result.setResultForFailure(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.warn("Problem with Parser Config", (Throwable)e);
            result.setResultForFailure(e.getMessage());
        }
    }

    private static String errorDetails(SAXParseException spe) {
        StringBuilder str = new StringBuilder(80);
        int i = spe.getLineNumber();
        if (i != -1) {
            str.append("line=");
            str.append(i);
            str.append(" col=");
            str.append(spe.getColumnNumber());
            str.append(" ");
        }
        str.append(spe.getLocalizedMessage());
        return str.toString();
    }

    private static class SAXErrorHandler
    implements ErrorHandler {
        private final AssertionResult result;

        public SAXErrorHandler(AssertionResult result) {
            this.result = result;
        }

        @Override
        public void error(SAXParseException exception) throws SAXParseException {
            String msg = "error: " + XMLSchemaAssertion.errorDetails(exception);
            log.debug(msg);
            this.result.setFailureMessage(msg);
            this.result.setError(true);
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXParseException {
            String msg = "fatal: " + XMLSchemaAssertion.errorDetails(exception);
            log.debug(msg);
            this.result.setFailureMessage(msg);
            this.result.setError(true);
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXParseException {
            String msg = "warning: " + XMLSchemaAssertion.errorDetails(exception);
            log.debug(msg);
            this.result.setFailureMessage(msg);
        }
    }
}

