/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.snapshot;

import org.apache.isis.core.runtime.snapshot.Helper;
import org.apache.isis.core.runtime.snapshot.IsisSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class XsMetaModel {
    private final Helper helper = new Helper();
    public static final String W3_ORG_XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String W3_ORG_XMLNS_PREFIX = "xmlns";
    public static final String W3_ORG_XS_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String W3_ORG_XS_PREFIX = "xs";
    public static final String W3_ORG_XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String W3_ORG_XSI_PREFIX = "xsi";
    private final IsisSchema nofMeta = new IsisSchema();

    Element createXsSchemaElement(Document xsdDoc) {
        if (xsdDoc.getDocumentElement() != null) {
            throw new IllegalArgumentException("XSD document already has content");
        }
        Element xsSchemaElement = this.createXsElement(xsdDoc, "schema");
        xsSchemaElement.setAttribute("elementFormDefault", "qualified");
        this.nofMeta.addNamespace(xsSchemaElement);
        xsdDoc.appendChild(xsSchemaElement);
        Element xsImportElement = this.createXsElement(xsdDoc, "import");
        xsImportElement.setAttribute("namespace", "http://isis.apache.org/ns/0.1/metamodel");
        xsImportElement.setAttribute("schemaLocation", "isis.xsd");
        xsSchemaElement.appendChild(xsImportElement);
        return xsSchemaElement;
    }

    Element createXsElementElement(Document xsdDoc, String className) {
        return this.createXsElementElement(xsdDoc, className, true);
    }

    Element createXsElementElement(Document xsdDoc, String className, boolean includeCardinality) {
        Element xsElementElement = this.createXsElement(xsdDoc, "element");
        xsElementElement.setAttribute("name", className);
        if (includeCardinality) {
            this.setXsCardinality(xsElementElement, 0, Integer.MAX_VALUE);
        }
        return xsElementElement;
    }

    Element createXsElement(Document xsdDoc, String localName) {
        Element element = xsdDoc.createElementNS(W3_ORG_XS_URI, "xs:" + localName);
        this.helper.rootElementFor(element).setAttributeNS(W3_ORG_XMLNS_URI, "xmlns:xs", W3_ORG_XS_URI);
        return element;
    }

    Element addXsNofAttribute(Element parentXsElement, String nofAttributeRef) {
        return this.addXsNofAttribute(parentXsElement, nofAttributeRef, null);
    }

    Element addXsNofAttribute(Element parentXsElement, String nofAttributeRef, String fixedValue) {
        return this.addXsNofAttribute(parentXsElement, nofAttributeRef, fixedValue, true);
    }

    Element addXsNofAttribute(Element parentXsElement, String nofAttributeRef, String value, boolean useFixed) {
        Element xsNofAttributeElement = this.createXsElement(this.helper.docFor(parentXsElement), "attribute");
        xsNofAttributeElement.setAttribute("ref", "nof:" + nofAttributeRef);
        parentXsElement.appendChild(xsNofAttributeElement);
        if (value != null) {
            if (useFixed) {
                xsNofAttributeElement.setAttribute("fixed", value);
            } else {
                xsNofAttributeElement.setAttribute("default", value);
            }
        }
        return parentXsElement;
    }

    Element addXsNofFeatureAttributeElements(Element parentXsElement, String feature) {
        Element xsNofFeatureAttributeElement = this.createXsElement(this.helper.docFor(parentXsElement), "attribute");
        xsNofFeatureAttributeElement.setAttribute("ref", "nof:feature");
        xsNofFeatureAttributeElement.setAttribute("fixed", feature);
        parentXsElement.appendChild(xsNofFeatureAttributeElement);
        return xsNofFeatureAttributeElement;
    }

    Element complexTypeFor(Element parentXsElement) {
        return this.complexTypeFor(parentXsElement, true);
    }

    Element complexTypeFor(Element parentXsElement, boolean mixed) {
        Element el = this.childXsElement(parentXsElement, "complexType");
        if (mixed) {
            el.setAttribute("mixed", "true");
        }
        return el;
    }

    Element sequenceFor(Element parentXsElement) {
        return this.childXsElement(parentXsElement, "sequence");
    }

    Element choiceFor(Element parentXsElement) {
        return this.childXsElement(parentXsElement, "choice");
    }

    Element sequenceForComplexTypeFor(Element parentXsElement) {
        return this.sequenceFor(this.complexTypeFor(parentXsElement));
    }

    Element choiceForComplexTypeFor(Element parentXsElement) {
        return this.choiceFor(this.complexTypeFor(parentXsElement));
    }

    Element choiceOrSequenceFor(Element parentXsElement) {
        NodeList choiceNodeList = parentXsElement.getElementsByTagNameNS(W3_ORG_XS_URI, "choice");
        if (choiceNodeList.getLength() > 0) {
            return (Element)choiceNodeList.item(0);
        }
        NodeList sequenceNodeList = parentXsElement.getElementsByTagNameNS(W3_ORG_XS_URI, "sequence");
        if (sequenceNodeList.getLength() > 0) {
            return (Element)sequenceNodeList.item(0);
        }
        return null;
    }

    Element simpleContentFor(Element parentXsElement) {
        return this.childXsElement(parentXsElement, "simpleContent");
    }

    Element extensionFor(Element parentXsElement, String base) {
        Element childXsElement = this.childXsElement(parentXsElement, "extension");
        childXsElement.setAttribute("base", "xs:" + base);
        return childXsElement;
    }

    Element childXsElement(Element parentXsElement, String localName) {
        NodeList nodeList = parentXsElement.getElementsByTagNameNS(W3_ORG_XS_URI, localName);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        Element childXsElement = this.createXsElement(this.helper.docFor(parentXsElement), localName);
        parentXsElement.appendChild(childXsElement);
        return childXsElement;
    }

    Element schemaFor(Element xsElement) {
        return xsElement.getOwnerDocument().getDocumentElement();
    }

    Element setXsCardinality(Element xsElement, int minOccurs, int maxOccurs) {
        if (maxOccurs >= 0) {
            xsElement.setAttribute("minOccurs", "" + minOccurs);
        }
        if (maxOccurs >= 0) {
            if (maxOccurs == Integer.MAX_VALUE) {
                xsElement.setAttribute("maxOccurs", "unbounded");
            } else {
                xsElement.setAttribute("maxOccurs", "" + maxOccurs);
            }
        }
        return xsElement;
    }
}

