/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.snapshot;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.runtime.snapshot.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class IsisSchema {
    public static final String DEFAULT_LOCATION = "isis.xsd";
    public static final String DEFAULT_URI_BASE = "http://isis.apache.org/ns/app/";
    public static final String FEATURE_CLASS = "class";
    public static final String FEATURE_COLLECTION = "collection";
    public static final String FEATURE_REFERENCE = "reference";
    public static final String FEATURE_VALUE = "value";
    public static final String NS_PREFIX = "nof";
    public static final String NS_URI = "http://isis.apache.org/ns/0.1/metamodel";
    private final Helper helper = new Helper();

    void addNamespace(Element element) {
        this.helper.rootElementFor(element).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:nof", NS_URI);
    }

    Element appendElement(Element parentElement, String localName) {
        Element element = this.helper.docFor(parentElement).createElementNS(NS_URI, "nof:" + localName);
        parentElement.appendChild(element);
        return element;
    }

    public void appendNofTitle(Element element, String titleStr) {
        Document doc = this.helper.docFor(element);
        Element titleElement = this.appendElement(element, "title");
        titleElement.appendChild(doc.createTextNode(titleStr));
    }

    String getAttribute(Element element, String attributeName) {
        return element.getAttributeNS(NS_URI, attributeName);
    }

    void setAnnotationAttribute(Element element, String annotation) {
        this.setAttribute(element, "annotation", "nof:" + annotation);
    }

    private void setAttribute(Element element, String attributeName, String attributeValue) {
        element.setAttributeNS(NS_URI, "nof:" + attributeName, attributeValue);
    }

    void setAttributesForClass(Element element, String oid) {
        this.setAttribute(element, "feature", FEATURE_CLASS);
        this.setAttribute(element, "oid", oid);
    }

    void setAttributesForReference(Element element, String prefix, String fullyQualifiedClassName) {
        this.setAttribute(element, "feature", FEATURE_REFERENCE);
        this.setAttribute(element, "type", prefix + ":" + fullyQualifiedClassName);
    }

    void setAttributesForValue(Element element, String datatypeName) {
        this.setAttribute(element, "feature", FEATURE_VALUE);
        this.setAttribute(element, "datatype", "nof:" + datatypeName);
    }

    void setIsEmptyAttribute(Element element, boolean isEmpty) {
        this.setAttribute(element, "isEmpty", "" + isEmpty);
    }

    void setIsisCollection(Element element, String prefix, String fullyQualifiedClassName, ObjectAdapter collection) {
        this.setAttribute(element, "feature", FEATURE_COLLECTION);
        this.setAttribute(element, "type", prefix + ":" + fullyQualifiedClassName);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
        this.setAttribute(element, "size", "" + facet.size(collection));
    }
}

