/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.profiler;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.isis.core.runtime.profiler.ProfilerSystem;

public class Profiler {
    private static final String DELIMITER = "\t";
    private static NumberFormat FLOAT_FORMAT = NumberFormat.getNumberInstance(Locale.UK);
    private static NumberFormat INTEGER_FORMAT = NumberFormat.getNumberInstance(Locale.UK);
    private static final Map<Thread, String> threads = new HashMap<Thread, String>();
    private static int nextId = 0;
    private static int nextThread = 0;
    protected static ProfilerSystem profilerSystem = new ProfilerSystem();
    private final String thread;
    private final int id;
    private final String name;
    private long elapsedTime = 0L;
    private long memory;
    private long start = 0L;
    private boolean timing = false;

    public static void setProfilerSystem(ProfilerSystem profilerSystem) {
        Profiler.profilerSystem = profilerSystem;
    }

    public static String memoryLog() {
        long free = Profiler.memory();
        return INTEGER_FORMAT.format(free) + " bytes";
    }

    private static long time() {
        return profilerSystem.time();
    }

    private static long memory() {
        return profilerSystem.memory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler(String name) {
        this.name = name;
        Class<Profiler> clazz = Profiler.class;
        synchronized (Profiler.class) {
            this.id = nextId++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Thread t = Thread.currentThread();
            String thread = threads.get(t);
            if (thread != null) {
                this.thread = thread;
            } else {
                this.thread = "t" + nextThread++;
                threads.put(t, this.thread);
            }
            this.memory = Profiler.memory();
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    public void reset() {
        this.elapsedTime = 0L;
        this.start = Profiler.time();
        this.memory = Profiler.memory();
    }

    public void start() {
        this.start = Profiler.time();
        this.timing = true;
    }

    public void stop() {
        this.timing = false;
        long end = Profiler.time();
        this.elapsedTime += end - this.start;
    }

    public long getElapsedTime() {
        return this.timing ? Profiler.time() - this.start : this.elapsedTime;
    }

    public long getMemoryUsage() {
        return Profiler.memory() - this.memory;
    }

    public String memoryUsageLog() {
        return INTEGER_FORMAT.format(this.getMemoryUsage()) + " bytes";
    }

    public String timeLog() {
        return FLOAT_FORMAT.format((double)this.getElapsedTime() / 1000.0) + " secs";
    }

    public String log() {
        return this.id + DELIMITER + this.thread + DELIMITER + this.getName() + DELIMITER + this.getMemoryUsage() + DELIMITER + this.getElapsedTime();
    }

    public String toString() {
        return this.getElapsedTime() + "ms - " + this.name;
    }
}

