/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.logging;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.isis.core.runtime.logging.SnapshotAppender;
import org.apache.isis.core.runtime.logging.SnapshotWriter;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class FileSnapshotAppender
extends SnapshotAppender {
    private static final Logger LOG = Logger.getLogger(FileSnapshotAppender.class);
    private String directoryPath;
    private String extension;
    private String fileName = "log-snapshot-";

    public FileSnapshotAppender(TriggeringEventEvaluator evaluator) {
        super(evaluator);
    }

    public FileSnapshotAppender() {
    }

    public synchronized String getDirectory() {
        return this.directoryPath;
    }

    public synchronized String getExtension() {
        return this.extension;
    }

    public synchronized String getFileName() {
        return this.fileName;
    }

    public synchronized void setDirectory(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public synchronized void setExtension(String extension) {
        this.extension = extension;
    }

    public synchronized void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    protected synchronized void writeSnapshot(String message, String details) {
        try {
            String contentType = this.layout.getContentType();
            String fileExtension = this.isEmpty(this.extension) ? contentType.substring(contentType.indexOf(47) + 1) : this.extension;
            SnapshotWriter s = new SnapshotWriter(this.directoryPath, this.fileName, fileExtension, message);
            s.appendLog(details);
            s.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"failed to open log file", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"failed to write log file", (Throwable)e);
        }
    }

    private boolean isEmpty(String extension2) {
        return extension2 == null || extension2.length() == 0;
    }
}

