/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authorization.standard;

import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.applib.events.VisibilityEvent;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.authorization.standard.AuthorizationFacet;

public abstract class AuthorizationFacetAbstract
extends FacetAbstract
implements AuthorizationFacet {
    private final AuthorizationManager authorizationManager;

    public static Class<? extends Facet> type() {
        return AuthorizationFacet.class;
    }

    public AuthorizationFacetAbstract(FacetHolder holder, AuthorizationManager authorizationManager) {
        super(AuthorizationFacetAbstract.type(), holder, false);
        this.authorizationManager = authorizationManager;
    }

    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        return this.authorizationManager.isVisible(ic.getSession(), ic.getTarget(), ic.getIdentifier()) ? null : "Not authorized to view";
    }

    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        return this.authorizationManager.isUsable(ic.getSession(), ic.getTarget(), ic.getIdentifier()) ? null : "Not authorized to edit";
    }
}

