/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.percentage;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.applib.value.Percentage;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.floats.FloatingPointValueFacet;

public class PercentageValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<Percentage>
implements FloatingPointValueFacet {
    private static final NumberFormat PERCENTAGE_FORMAT = NumberFormat.getPercentInstance();
    private static final NumberFormat DECIMAL_FORMAT = NumberFormat.getNumberInstance();
    private static final Percentage DEFAULT_VALUE = new Percentage(0.0f);
    private static final int TYPICAL_LENGTH = 12;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private NumberFormat format = PERCENTAGE_FORMAT;

    public static Class<? extends Facet> type() {
        return FloatingPointValueFacet.class;
    }

    public PercentageValueSemanticsProvider() {
        this(null, null, null);
    }

    public PercentageValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(PercentageValueSemanticsProvider.type(), holder, Percentage.class, 12, true, true, DEFAULT_VALUE, configuration, context);
        String formatRequired = configuration.getString("isis.value.format.percentage");
        this.format = formatRequired == null ? PERCENTAGE_FORMAT : new DecimalFormat(formatRequired);
    }

    @Override
    protected Percentage doParse(Object context, String text) {
        try {
            return new Percentage(new Float(this.format.parse(text).floatValue()).floatValue());
        }
        catch (ParseException e) {
            try {
                return new Percentage(this.asFloat(text).floatValue());
            }
            catch (ParseException ee) {
                throw new TextEntryParseException("Not a number " + text, (Throwable)ee);
            }
        }
    }

    private Float asFloat(String text) throws ParseException {
        return new Float(DECIMAL_FORMAT.parse(text).floatValue());
    }

    @Override
    public String titleString(Object value, Localization localization) {
        return this.titleString(this.format, value);
    }

    private String titleString(NumberFormat formatter, Object value) {
        return value == null ? "" : this.format.format(((Percentage)value).floatValue());
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        Percentage per = (Percentage)object;
        return String.valueOf(per.floatValue());
    }

    @Override
    protected Percentage doRestore(String data) {
        return new Percentage(Float.valueOf(data).floatValue());
    }

    @Override
    public Float floatValue(ObjectAdapter object) {
        Percentage per = (Percentage)object.getObject();
        return new Float(per.floatValue());
    }

    @Override
    public ObjectAdapter createValue(Float value) {
        return this.getAdapterMap().adapterFor((Object)value);
    }

    public Object getDefault(ObjectAdapter inObject) {
        return Float.valueOf(0.0f);
    }

    public String toString() {
        return "PercentageValueSemanticsProvider: " + this.format;
    }
}

