/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.integer;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.integer.IntegerValueFacet;

public abstract class IntValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Integer>
implements IntegerValueFacet {
    private static final Integer DEFAULT_VALUE = 0;
    private static final int TYPICAL_LENGTH = 9;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private final NumberFormat format = this.determineNumberFormat("value.format.int");

    public static Class<? extends Facet> type() {
        return IntegerValueFacet.class;
    }

    public IntValueSemanticsProviderAbstract(FacetHolder holder, Class<Integer> adaptedClass, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(IntValueSemanticsProviderAbstract.type(), holder, adaptedClass, 9, true, true, DEFAULT_VALUE, configuration, context);
    }

    @Override
    protected Integer doParse(Object context, String entry) {
        try {
            return this.format.parse(entry).intValue();
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not an whole number " + entry, (Throwable)e);
        }
    }

    @Override
    public String titleString(Object value, Localization localization) {
        return this.titleString(this.format, value);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Integer doRestore(String data) {
        return new Integer(data);
    }

    @Override
    public Integer integerValue(ObjectAdapter object) {
        return (Integer)(object == null ? null : object.getObject());
    }

    @Override
    public ObjectAdapter createValue(Integer value) {
        return value == null ? null : this.getAdapterMap().adapterFor((Object)value);
    }

    public String toString() {
        return "IntegerValueSemanticsProvider: " + this.format;
    }
}

