/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.date;

import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Map;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.ValueSemanticsProviderAbstractTemporal;

public abstract class DateValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAbstractTemporal<T> {
    private static Map<String, DateFormat> formats = Maps.newHashMap();

    public DateValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, boolean immutable, boolean equalByContent, T defaultValue, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super("date", holder, adaptedClass, 12, immutable, equalByContent, defaultValue, configuration, context);
        String formatRequired = configuration.getString("isis.value.format.date");
        if (formatRequired == null) {
            this.format = this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    protected void clearFields(Calendar cal) {
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(9, 0);
        cal.set(14, 0);
    }

    @Override
    protected String defaultFormat() {
        return "medium";
    }

    @Override
    protected boolean ignoreTimeZone() {
        return true;
    }

    @Override
    protected Map<String, DateFormat> formats() {
        return formats;
    }

    public String toString() {
        return "DateValueSemanticsProvider: " + this.format;
    }

    static {
        formats.put("iso", DateValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd"));
        formats.put("iso_encoding", DateValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd"));
        formats.put("long", DateFormat.getDateInstance(1));
        formats.put("medium", DateFormat.getDateInstance(2));
        formats.put("short", DateFormat.getDateInstance(3));
    }
}

