/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value;

import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.util.Map;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.ValueSemanticsProviderAbstractTemporal;

public abstract class DateAndTimeValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAbstractTemporal<T> {
    private static Map<String, DateFormat> formats = Maps.newHashMap();
    private static final Object DEFAULT_VALUE;
    private static final int TYPICAL_LENGTH = 18;

    public DateAndTimeValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, boolean immutable, boolean equalByContent, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super("datetime", holder, adaptedClass, 18, immutable, equalByContent, DEFAULT_VALUE, configuration, context);
        String formatRequired = configuration.getString("isis.value.format.datetime");
        if (formatRequired == null) {
            this.format = this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    @Override
    public int getLevel() {
        return 17;
    }

    @Override
    protected String defaultFormat() {
        return "medium";
    }

    @Override
    protected Map<String, DateFormat> formats() {
        return formats;
    }

    @Override
    protected DateFormat format(Localization localization) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, localization.getLocale());
        dateFormat.setTimeZone(localization.getTimeZone());
        return dateFormat;
    }

    public String toString() {
        return "JavaDateTimeValueSemanticsProvider: " + this.format;
    }

    static {
        formats.put("iso", DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm"));
        formats.put("iso_short", DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd'T'HHmm"));
        formats.put("iso_sec", DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm:ss"));
        formats.put("iso_sec_short", DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd'T'HHmmss"));
        formats.put("iso_milli", DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        formats.put("iso_milli_short", DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("iso_encoding", DateAndTimeValueSemanticsProviderAbstract.createDateFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("long", DateFormat.getDateTimeInstance(1, 1));
        formats.put("medium", DateFormat.getDateTimeInstance(2, 3));
        formats.put("short", DateFormat.getDateTimeInstance(3, 3));
        formats.put("custom1", DateAndTimeValueSemanticsProviderAbstract.createDateFormat("dd-MMM-yyyy HH:mm"));
        DEFAULT_VALUE = null;
    }
}

