/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.modify;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.disable.staticmethod.DisabledFacetAlways;
import org.apache.isis.core.progmodel.facets.properties.derived.inferred.NotPersistableFacetInferred;
import org.apache.isis.core.progmodel.facets.properties.modify.PropertyClearFacetViaClearMethod;
import org.apache.isis.core.progmodel.facets.properties.modify.PropertyClearFacetViaSetterMethod;
import org.apache.isis.core.progmodel.facets.properties.modify.PropertyInitializationFacetViaSetterMethod;
import org.apache.isis.core.progmodel.facets.properties.modify.PropertySetterFacetViaSetterMethod;

public class PropertySetAndClearFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"set", "clear"};

    public PropertySetAndClearFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Method setMethod = PropertySetAndClearFacetFactory.attachPropertyModifyFacetIfSetterIsFound(processMethodContext);
        Method clearMethod = this.attachPropertyClearFacetIfClearMethodIsFound(processMethodContext);
        PropertySetAndClearFacetFactory.attachPropertyClearFacetUsingSetterIfRequired(processMethodContext, setMethod, clearMethod);
    }

    private static Method attachPropertyModifyFacetIfSetterIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseName((String)getMethod.getName());
        Class cls = processMethodContext.getCls();
        Class<?> returnType = getMethod.getReturnType();
        Class[] paramTypes = new Class[]{returnType};
        Method setMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "set" + capitalizedName, Void.TYPE, paramTypes);
        processMethodContext.removeMethod(setMethod);
        FacetHolder property = processMethodContext.getFacetHolder();
        if (setMethod != null) {
            FacetUtil.addFacet((Facet)new PropertySetterFacetViaSetterMethod(setMethod, property));
            FacetUtil.addFacet((Facet)new PropertyInitializationFacetViaSetterMethod(setMethod, property));
        } else {
            FacetUtil.addFacet((Facet)new NotPersistableFacetInferred(property));
            FacetUtil.addFacet((Facet)new DisabledFacetAlways(property));
        }
        return setMethod;
    }

    private Method attachPropertyClearFacetIfClearMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Class cls = processMethodContext.getCls();
        Method getMethod = processMethodContext.getMethod();
        FacetHolder property = processMethodContext.getFacetHolder();
        String capitalizedName = NameUtils.javaBaseName((String)getMethod.getName());
        Method clearMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "clear" + capitalizedName, Void.TYPE, NO_PARAMETERS_TYPES);
        if (clearMethod == null) {
            return null;
        }
        processMethodContext.removeMethod(clearMethod);
        FacetUtil.addFacet((Facet)new PropertyClearFacetViaClearMethod(clearMethod, property));
        return clearMethod;
    }

    private static void attachPropertyClearFacetUsingSetterIfRequired(FacetFactory.ProcessMethodContext processMethodContext, Method setMethod, Method clearMethod) {
        if (clearMethod != null) {
            return;
        }
        if (setMethod == null) {
            return;
        }
        FacetHolder property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new PropertyClearFacetViaSetterMethod(setMethod, property));
    }
}

