/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.defaults.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.progmodel.facets.properties.defaults.PropertyDefaultFacetAbstract;

public class PropertyDefaultFacetViaMethod
extends PropertyDefaultFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final SpecificationLookup specificationLookup;
    private final AdapterMap adapterMap;

    public PropertyDefaultFacetViaMethod(Method method, FacetHolder holder, SpecificationLookup specificationLookup, AdapterMap adapterManager) {
        super(holder);
        this.method = method;
        this.specificationLookup = specificationLookup;
        this.adapterMap = adapterManager;
    }

    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    public boolean impliesResolve() {
        return true;
    }

    public boolean impliesObjectChanged() {
        return false;
    }

    public ObjectAdapter getDefault(ObjectAdapter owningAdapter) {
        Object result = AdapterInvokeUtils.invoke((Method)this.method, (ObjectAdapter)owningAdapter);
        if (result == null) {
            return null;
        }
        return this.createAdapter(this.method.getReturnType(), result);
    }

    private ObjectAdapter createAdapter(Class<?> type, Object object) {
        ObjectSpecification specification = this.getSpecificationLookup().loadSpecification(type);
        if (specification.isNotCollection()) {
            return this.getAdapterMap().adapterFor(object);
        }
        throw new UnknownTypeException("not an object, is this a collection?");
    }

    protected String toStringValues() {
        return "method=" + this.method;
    }

    private SpecificationLookup getSpecificationLookup() {
        return this.specificationLookup;
    }

    protected AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

