/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.defaults.methodnum;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.param.defaults.methodnum.ActionParameterDefaultsFacetViaMethod;

public class ActionParameterDefaultsFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[0];

    public ActionParameterDefaultsFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List holderList = facetedMethod.getParameters();
        ActionParameterDefaultsFacetFactory.attachDefaultFacetForParametersIfDefaultsNumMethodIsFound(processMethodContext, holderList);
    }

    private static void attachDefaultFacetForParametersIfDefaultsNumMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Class cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        Class<?>[] paramTypes = actionMethod.getParameterTypes();
        String capitalizedName = NameUtils.capitalizeName((String)actionMethod.getName());
        for (int i = 0; i < paramTypes.length; ++i) {
            Method defaultMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "default" + i + capitalizedName, paramTypes[i], new Class[0]);
            if (defaultMethod == null) continue;
            processMethodContext.removeMethod(defaultMethod);
            FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
            if (facetedMethod.containsDoOpFacet(ActionDefaultsFacet.class)) {
                throw new MetaModelException(cls + " uses both old and new default syntax for " + actionMethod.getName() + "(...) - must use one or other");
            }
            FacetedMethodParameter paramAsHolder = parameters.get(i);
            FacetUtil.addFacet((Facet)new ActionParameterDefaultsFacetViaMethod(defaultMethod, (FacetHolder)paramAsHolder));
        }
    }
}

