/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.value.annotation;

import org.apache.isis.applib.annotation.Value;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.progmodel.facets.object.value.ValueFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderUtil;

public class ValueFacetAnnotation
extends ValueFacetAbstract {
    private static String semanticsProviderName(Class<?> annotatedClass, IsisConfiguration configuration) {
        Value annotation = annotatedClass.getAnnotation(Value.class);
        String semanticsProviderName = annotation.semanticsProviderName();
        if (!StringUtils.isNullOrEmpty((String)semanticsProviderName)) {
            return semanticsProviderName;
        }
        return ValueSemanticsProviderUtil.semanticsProviderNameFromConfiguration(annotatedClass, configuration);
    }

    private static Class<?> semanticsProviderClass(Class<?> annotatedClass) {
        Value annotation = annotatedClass.getAnnotation(Value.class);
        return annotation.semanticsProviderClass();
    }

    public ValueFacetAnnotation(Class<?> annotatedClass, FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        this(ValueFacetAnnotation.semanticsProviderName(annotatedClass, configuration), ValueFacetAnnotation.semanticsProviderClass(annotatedClass), holder, configuration, context);
    }

    private ValueFacetAnnotation(String candidateSemanticsProviderName, Class<?> candidateSemanticsProviderClass, FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(ValueSemanticsProviderUtil.valueSemanticsProviderOrNull(candidateSemanticsProviderClass, candidateSemanticsProviderName), ValueFacetAbstract.AddFacetsIfInvalidStrategy.DO_ADD, holder, configuration, context);
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

