/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.title.annotation;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.metamodel.adapter.LocalizationProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacetAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.log4j.Logger;

public class TitleFacetViaTitleAnnotation
extends TitleFacetAbstract {
    private static final Logger LOG = Logger.getLogger(TitleFacetViaTitleAnnotation.class);
    private final List<TitleComponent> components;
    private final AdapterMap adapterMap;
    private final LocalizationProvider localizationProvider;

    public TitleFacetViaTitleAnnotation(List<TitleComponent> components, FacetHolder holder, AdapterMap adapterMap, LocalizationProvider localizationProvider) {
        super(holder);
        this.components = components;
        this.adapterMap = adapterMap;
        this.localizationProvider = localizationProvider;
    }

    public String title(ObjectAdapter owningAdapter, Localization localization) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (TitleComponent component : this.components) {
                String title = null;
                Object titlePart = AdapterInvokeUtils.invoke((Method)component.getMethod(), (ObjectAdapter)owningAdapter);
                if (titlePart != null && Strings.isNullOrEmpty((String)(title = this.titleOf(titlePart)))) {
                    title = titlePart.toString().trim();
                }
                if (Strings.isNullOrEmpty(title)) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(component.getPrepend());
                }
                stringBuilder.append(TitleFacetViaTitleAnnotation.abbreviated(title, component.abbreviateTo));
                stringBuilder.append(component.getAppend());
            }
            return stringBuilder.toString().trim();
        }
        catch (RuntimeException ex) {
            LOG.warn((Object)"Title failure", (Throwable)ex);
            return "Failed Title";
        }
    }

    private String titleOf(Object domainObject) {
        ObjectAdapter adapter = this.adapterMap.getAdapterFor(domainObject);
        if (adapter == null) {
            return null;
        }
        ObjectSpecification returnSpec = adapter.getSpecification();
        if (!returnSpec.containsFacet(TitleFacet.class)) {
            return null;
        }
        return returnSpec.getTitle(adapter, this.localizationProvider.getLocalization());
    }

    public List<TitleComponent> getComponents() {
        return this.components;
    }

    private static String abbreviated(String str, int maxLength) {
        return str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...";
    }

    public static class TitleComponent {
        public static final Function<? super Method, ? extends TitleComponent> FROM_METHOD = new Function<Method, TitleComponent>(){

            public TitleComponent apply(Method input) {
                return TitleComponent.of(input);
            }
        };
        private final String prepend;
        private final String append;
        private final Method method;
        private final int abbreviateTo;

        private TitleComponent(String prepend, String append, Method method, int abbreviateTo) {
            this.prepend = prepend;
            this.append = append;
            this.method = method;
            this.abbreviateTo = abbreviateTo;
        }

        public String getPrepend() {
            return this.prepend;
        }

        public String getAppend() {
            return this.append;
        }

        public Method getMethod() {
            return this.method;
        }

        public static TitleComponent of(Method method) {
            Title annotation = method.getAnnotation(Title.class);
            String prepend = annotation != null ? annotation.prepend() : " ";
            String append = annotation != null ? annotation.append() : "";
            int abbreviateTo = annotation != null ? annotation.abbreviatedTo() : Integer.MAX_VALUE;
            return new TitleComponent(prepend, append, method, abbreviateTo);
        }
    }
}

