/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.title.annotation;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.core.metamodel.adapter.LocalizationProvider;
import org.apache.isis.core.metamodel.adapter.LocalizationProviderAware;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.object.title.annotation.TitleFacetViaTitleAnnotation;

public class TitleAnnotationFacetFactory
extends FacetFactoryAbstract
implements AdapterMapAware,
LocalizationProviderAware {
    private AdapterMap adapterMap;
    private LocalizationProvider localizationProvider;

    public TitleAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class cls = processClassContext.getCls();
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        List<Method> methods = MethodFinderUtils.findMethodsWithAnnotation(cls, MethodScope.OBJECT, Title.class);
        Collections.sort(methods, new Comparator<Method>(){
            Comparator<String> comparator = new SequenceComparator();

            @Override
            public int compare(Method o1, Method o2) {
                Title a1 = o1.getAnnotation(Title.class);
                Title a2 = o2.getAnnotation(Title.class);
                return this.comparator.compare(a1.sequence(), a2.sequence());
            }
        });
        if (methods.isEmpty()) {
            return;
        }
        List titleComponents = Lists.transform(methods, TitleFacetViaTitleAnnotation.TitleComponent.FROM_METHOD);
        FacetUtil.addFacet((Facet)new TitleFacetViaTitleAnnotation(titleComponents, facetHolder, this.adapterMap, this.localizationProvider));
    }

    public void setLocalizationProvider(LocalizationProvider localizationProvider) {
        this.localizationProvider = localizationProvider;
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterMap = adapterMap;
    }

    static class SequenceComparator
    implements Comparator<String> {
        SequenceComparator() {
        }

        @Override
        public int compare(String sequence1, String sequence2) {
            List<String> components1 = SequenceComparator.componentsFor(sequence1);
            List<String> components2 = SequenceComparator.componentsFor(sequence2);
            int size1 = components1.size();
            int size2 = components2.size();
            if (size1 == 0 && size2 == 0) {
                return 0;
            }
            int n = 0;
            int length;
            while (size1 >= (length = n + 1) || size2 < length) {
                if (size2 < length && size1 >= length) {
                    return 1;
                }
                if (size1 < length && size2 < length) {
                    return 0;
                }
                int componentCompare = 0;
                try {
                    Integer c1 = Integer.valueOf(components1.get(n));
                    Integer c2 = Integer.valueOf(components2.get(n));
                    componentCompare = c1.compareTo(c2);
                }
                catch (NumberFormatException nfe) {
                    componentCompare = components1.get(n).compareTo(components2.get(n));
                }
                if (componentCompare != 0) {
                    return componentCompare;
                }
                ++n;
            }
            return -1;
        }

        private static List<String> componentsFor(String sequence) {
            return Lists.newArrayList((Iterable)Splitter.on((char)'.').split((CharSequence)sequence));
        }
    }
}

